/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.system.controller;

import cn.hutool.core.util.StrUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.config.security.permission.MySecurityMetadataSource;
import plus.hiver.common.constant.HiverConstant;
import plus.hiver.common.entity.Permission;
import plus.hiver.common.entity.User;
import plus.hiver.common.exception.HiverException;
import plus.hiver.common.redis.RedisTemplateHelper;
import plus.hiver.common.service.PermissionService;
import plus.hiver.common.service.RolePermissionService;
import plus.hiver.common.service.mybatis.IPermissionService;
import plus.hiver.common.utils.CommonUtil;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.utils.SecurityUtil;
import plus.hiver.module.system.utils.VoUtil;
import plus.hiver.module.system.vo.MenuVo;

@RestController
@Tag(name="\u83dc\u5355\u6743\u9650\u7ba1\u7406\u63a5\u53e3")
@PermissionTag(permission="permission:*")
@RequestMapping(value={"/hiver/permission"})
@CacheConfig(cacheNames={"permission"})
@Transactional
public class PermissionController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PermissionController.class);
    @Resource
    private PermissionService permissionService;
    @Resource
    private RolePermissionService rolePermissionService;
    @Resource
    private IPermissionService iPermissionService;
    @Resource
    private SecurityUtil securityUtil;
    @Resource
    private MySecurityMetadataSource mySecurityMetadataSource;
    @Resource
    private RedisTemplateHelper redisTemplateHelper;

    @GetMapping(value={"/getMenuList"})
    @Operation(summary="\u83b7\u53d6\u7528\u6237\u9875\u9762\u83dc\u5355\u6570\u636e")
    public Result<List<MenuVo>> getAllMenuList() {
        User user = this.securityUtil.getCurrUserSimple();
        String string = "permission::userMenuList:" + user.getId();
        String string2 = this.redisTemplateHelper.get(string);
        if (StrUtil.isNotBlank((CharSequence)string2)) {
            List list = (List)new Gson().fromJson(string2, new TypeToken<List<MenuVo>>(){}.getType());
            return new ResultUtil().setData((Object)list);
        }
        List list = this.iPermissionService.findByUserId(user.getId());
        List<MenuVo> list2 = list.stream().filter(permission -> HiverConstant.PERMISSION_NAV.equals(permission.getType())).sorted(Comparator.comparing(Permission::getSortOrder)).map(VoUtil::permissionToMenuVo).collect(Collectors.toList());
        this.getMenuByRecursion(list2, list);
        this.redisTemplateHelper.set(string, new Gson().toJson(list2), 15L, TimeUnit.DAYS);
        return new ResultUtil().setData(list2);
    }

    private void getMenuByRecursion(List<MenuVo> list, List<Permission> list2) {
        list.forEach(menuVo -> {
            if (HiverConstant.LEVEL_TWO.equals(menuVo.getLevel())) {
                List<String> list2 = list2.stream().filter(permission -> menuVo.getId().equals(permission.getParentId()) && HiverConstant.PERMISSION_OPERATION.equals(permission.getType())).sorted(Comparator.comparing(Permission::getSortOrder)).map(Permission::getButtonType).collect(Collectors.toList());
                menuVo.setPermTypes(list2);
            } else {
                List<MenuVo> list3 = list2.stream().filter(permission -> menuVo.getId().equals(permission.getParentId()) && HiverConstant.PERMISSION_PAGE.equals(permission.getType())).sorted(Comparator.comparing(Permission::getSortOrder)).map(VoUtil::permissionToMenuVo).collect(Collectors.toList());
                menuVo.setChildren(list3);
                if (menuVo.getLevel() < 3) {
                    this.getMenuByRecursion(list3, list2);
                }
            }
        });
    }

    @GetMapping(value={"/getAllList"})
    @Operation(summary="\u83b7\u53d6\u6743\u9650\u83dc\u5355\u6811")
    @Cacheable(key="'allList'")
    public Result<List<Permission>> getAllList() {
        List list = this.permissionService.getAll();
        List<Permission> list2 = list.stream().filter(permission -> HiverConstant.LEVEL_ZERO.equals(permission.getLevel())).sorted(Comparator.comparing(Permission::getSortOrder)).collect(Collectors.toList());
        this.getAllByRecursion(list2, list);
        return new ResultUtil().setData(list2);
    }

    private void getAllByRecursion(List<Permission> list, List<Permission> list2) {
        list.forEach(permission -> {
            List<Permission> list2 = list2.stream().filter(permission2 -> permission.getId().equals(permission2.getParentId())).sorted(Comparator.comparing(Permission::getSortOrder)).collect(Collectors.toList());
            permission.setChildren(list2);
            this.setInfo((Permission)permission);
            if (permission.getLevel() < 3) {
                this.getAllByRecursion(list2, list2);
            }
        });
    }

    @GetMapping(value={"/getByParentId/{parentId}"})
    @Operation(summary="\u901a\u8fc7id\u83b7\u53d6")
    @Cacheable(key="#parentId")
    public Result<List<Permission>> getByParentId(@PathVariable Long l) {
        List list = this.permissionService.findByParentIdOrderBySortOrder(l);
        list.forEach(permission -> this.setInfo((Permission)permission));
        return ResultUtil.data((Object)list);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u6dfb\u52a0")
    @CacheEvict(key="'menuList'")
    public Result<Permission> add(Permission permission) {
        List list;
        if (permission.getId().equals(permission.getParentId())) {
            return ResultUtil.error((String)"\u4e0a\u7ea7\u8282\u70b9\u4e0d\u80fd\u4e3a\u81ea\u5df1");
        }
        if (HiverConstant.PERMISSION_OPERATION.equals(permission.getType()) && (list = this.permissionService.findByTitle(permission.getTitle())) != null && list.size() > 0) {
            return new ResultUtil().setErrorMsg("\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (!("0".equals(permission.getParentId().toString()) || (list = (Permission)this.permissionService.get((Serializable)permission.getParentId())).getIsParent() != null && list.getIsParent().booleanValue())) {
            list.setIsParent(true);
            this.permissionService.update((Object)list);
        }
        list = (Permission)this.permissionService.save((Object)permission);
        this.mySecurityMetadataSource.loadResourceDefine();
        this.redisTemplateHelper.deleteByPattern("permission:*");
        return new ResultUtil().setData((Object)list);
    }

    @PostMapping(value={"/edit"})
    @Operation(summary="\u7f16\u8f91")
    public Result<Permission> edit(Permission permission) {
        Object object;
        Permission permission2;
        if (permission.getId().equals(permission.getParentId())) {
            return ResultUtil.error((String)"\u4e0a\u7ea7\u8282\u70b9\u4e0d\u80fd\u4e3a\u81ea\u5df1");
        }
        if (HiverConstant.PERMISSION_OPERATION.equals(permission.getType()) && !(permission2 = (Permission)this.permissionService.get((Serializable)permission.getId())).getTitle().equals(permission.getTitle()) && (object = this.permissionService.findByTitle(permission.getTitle())) != null && object.size() > 0) {
            return ResultUtil.error((String)"\u540d\u79f0\u5df2\u5b58\u5728");
        }
        permission2 = (Permission)this.permissionService.get((Serializable)permission.getId());
        object = permission2.getParentId();
        Permission permission3 = (Permission)this.permissionService.update((Object)permission);
        if (!"0".equals(((Long)object).toString()) && !((Long)object).equals(permission.getParentId())) {
            Permission permission4 = (Permission)this.permissionService.get((Serializable)object);
            List list = this.permissionService.findByParentIdOrderBySortOrder(permission4.getId());
            if (permission4 != null && (list == null || list.isEmpty())) {
                permission4.setIsParent(Boolean.valueOf(false));
                this.permissionService.update((Object)permission4);
            }
        }
        this.mySecurityMetadataSource.loadResourceDefine();
        this.redisTemplateHelper.deleteByPattern("user:*");
        this.redisTemplateHelper.deleteByPattern("permission:*");
        return ResultUtil.data((Object)permission3);
    }

    @PostMapping(value={"/delByIds"})
    @Operation(summary="\u6279\u91cf\u901a\u8fc7id\u5220\u9664")
    @CacheEvict(key="'menuList'")
    public Result delByIds(@RequestParam Long[] longArray) {
        for (Long l : longArray) {
            this.deleteRecursion(l, longArray);
        }
        this.mySecurityMetadataSource.loadResourceDefine();
        this.redisTemplateHelper.deleteByPattern("permission:*");
        return ResultUtil.success((String)"\u6279\u91cf\u901a\u8fc7id\u5220\u9664\u6570\u636e\u6210\u529f");
    }

    public void deleteRecursion(Long l, Long[] longArray) {
        List list;
        List list2 = this.rolePermissionService.findByPermissionId(l);
        if (list2 != null && list2.size() > 0) {
            throw new HiverException("\u5220\u9664\u5931\u8d25\uff0c\u5305\u542b\u6b63\u88ab\u7528\u6237\u4f7f\u7528\u5173\u8054\u7684\u83dc\u5355");
        }
        Permission permission = (Permission)this.permissionService.get((Serializable)l);
        Permission permission2 = (Permission)this.permissionService.findById((Serializable)permission.getParentId());
        this.permissionService.delete((Serializable)l);
        if (permission2 != null && ((list = this.permissionService.findByParentIdOrderBySortOrder(permission2.getId())) == null || list.isEmpty())) {
            permission2.setIsParent(Boolean.valueOf(false));
            this.permissionService.update((Object)permission2);
        }
        list = this.permissionService.findByParentIdOrderBySortOrder(l);
        for (Permission permission3 : list) {
            if (CommonUtil.judgeIds((Long)permission3.getId(), (Long[])longArray).booleanValue()) continue;
            this.deleteRecursion(permission3.getId(), longArray);
        }
    }

    @GetMapping(value={"/search"})
    @Operation(summary="\u641c\u7d22\u83dc\u5355")
    public Result<List<Permission>> searchPermissionList(@RequestParam String string) {
        List list = this.permissionService.findByTitleLikeOrderBySortOrder("%" + string + "%");
        list.forEach(permission -> this.setInfo((Permission)permission));
        return new ResultUtil().setData((Object)list);
    }

    public void setInfo(Permission permission) {
        if (!"0".equals(permission.getParentId().toString())) {
            Permission permission2 = (Permission)this.permissionService.get((Serializable)permission.getParentId());
            permission.setParentTitle(permission2.getTitle());
        } else {
            permission.setParentTitle("\u4e00\u7ea7\u83dc\u5355");
        }
    }

    @Generated
    public PermissionController(PermissionService permissionService, RolePermissionService rolePermissionService, IPermissionService iPermissionService, SecurityUtil securityUtil, MySecurityMetadataSource mySecurityMetadataSource, RedisTemplateHelper redisTemplateHelper) {
        this.permissionService = permissionService;
        this.rolePermissionService = rolePermissionService;
        this.iPermissionService = iPermissionService;
        this.securityUtil = securityUtil;
        this.mySecurityMetadataSource = mySecurityMetadataSource;
        this.redisTemplateHelper = redisTemplateHelper;
    }
}

