/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.system.controller;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.redis.RedisTemplateHelper;
import plus.hiver.common.utils.PageUtil;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.vo.PageVo;
import plus.hiver.module.system.vo.RedisInfo;
import plus.hiver.module.system.vo.RedisVo;

@RestController
@Tag(name="Redis\u7f13\u5b58\u7ba1\u7406\u63a5\u53e3")
@PermissionTag(permission="redis:*")
@RequestMapping(value={"/hiver/redis"})
@Transactional
public class RedisController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisController.class);
    private static final int maxSize = 100000;
    @Resource
    private RedisTemplateHelper redisTemplateHelper;

    @GetMapping(value={"/getAllByPage"})
    @Operation(summary="\u5206\u9875\u83b7\u53d6\u5168\u90e8")
    public Result<Page<RedisVo>> getAllByPage(@RequestParam(required=false) String object, PageVo pageVo) {
        ArrayList<RedisVo> arrayList = new ArrayList<RedisVo>();
        Set set = this.redisTemplateHelper.scan((String)(object = StrUtil.isNotBlank((CharSequence)object) ? "*" + (String)object + "*" : "*"));
        int n = set.size();
        if (n > 100000) {
            n = 100000;
        }
        int n2 = 0;
        for (String string : set) {
            if (n2 > n) break;
            RedisVo redisVo2 = new RedisVo(string, "", null);
            arrayList.add(redisVo2);
            ++n2;
        }
        PageImpl pageImpl = new PageImpl(PageUtil.listToPage((PageVo)pageVo, arrayList), PageUtil.initPage((PageVo)pageVo), (long)n);
        pageImpl.getContent().forEach(redisVo -> {
            Object object = "";
            try {
                object = this.redisTemplateHelper.get(redisVo.getKey());
                if (((String)object).length() > 150) {
                    object = ((String)object).substring(0, 150) + "...";
                }
            }
            catch (Exception exception) {
                object = "\u975e\u5b57\u7b26\u683c\u5f0f\u6570\u636e";
            }
            redisVo.setValue((String)object);
            redisVo.setExpireTime(this.redisTemplateHelper.getExpire(redisVo.getKey(), TimeUnit.SECONDS));
        });
        return new ResultUtil().setData((Object)pageImpl);
    }

    @GetMapping(value={"/getByKey/{key}"})
    @Operation(summary="\u901a\u8fc7key\u83b7\u53d6")
    public Result getByKey(@PathVariable String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string2 = this.redisTemplateHelper.get(string);
        Long l = this.redisTemplateHelper.getExpire(string, TimeUnit.SECONDS);
        hashMap.put("value", string2);
        hashMap.put("expireTime", l);
        return ResultUtil.data(hashMap);
    }

    @PostMapping(value={"/save"})
    @Operation(summary="\u6dfb\u52a0\u6216\u7f16\u8f91")
    public Result save(@RequestParam String string, @RequestParam String string2, @RequestParam Long l) {
        if (l < 0L) {
            this.redisTemplateHelper.set(string, string2);
        } else if (l > 0L) {
            this.redisTemplateHelper.set(string, string2, l.longValue(), TimeUnit.SECONDS);
        }
        return ResultUtil.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/delByKeys"})
    @Operation(summary="\u6279\u91cf\u5220\u9664")
    public Result delByKeys(@RequestParam String[] stringArray) {
        for (String string : stringArray) {
            this.redisTemplateHelper.delete(string);
        }
        return ResultUtil.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/delAll"})
    @Operation(summary="\u5168\u90e8\u5220\u9664")
    public Result delAll() {
        this.redisTemplateHelper.deleteByPattern("*");
        return ResultUtil.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/getKeySize"})
    @Operation(summary="\u83b7\u53d6\u5b9e\u65f6key\u5927\u5c0f")
    public Result getKeySize() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(16);
        hashMap.put("keySize", this.redisTemplateHelper.getConnectionFactory().getConnection().dbSize());
        hashMap.put("time", DateUtil.format((Date)new Date(), (String)"HH:mm:ss"));
        return ResultUtil.data(hashMap);
    }

    @GetMapping(value={"/getMemory"})
    @Operation(summary="\u83b7\u53d6\u5b9e\u65f6\u5185\u5b58\u5927\u5c0f")
    public Result getMemory() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(16);
        Properties properties = this.redisTemplateHelper.getConnectionFactory().getConnection().info("memory");
        hashMap.put("memory", properties.get("used_memory"));
        hashMap.put("time", DateUtil.format((Date)new Date(), (String)"HH:mm:ss"));
        return ResultUtil.data(hashMap);
    }

    @GetMapping(value={"/info"})
    @Operation(summary="\u83b7\u53d6Redis\u4fe1\u606f")
    public Result info() {
        ArrayList<RedisInfo> arrayList = new ArrayList<RedisInfo>();
        Properties properties = this.redisTemplateHelper.getConnectionFactory().getConnection().info();
        Set<Object> set = properties.keySet();
        for (Object object : set) {
            String string = properties.get(object).toString();
            RedisInfo redisInfo = new RedisInfo();
            redisInfo.setKey(object.toString());
            redisInfo.setValue(string);
            arrayList.add(redisInfo);
        }
        return ResultUtil.data(arrayList);
    }

    @Generated
    public RedisController(RedisTemplateHelper redisTemplateHelper) {
        this.redisTemplateHelper = redisTemplateHelper;
    }
}

