/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.system.controller;

import cn.hutool.core.util.StrUtil;
import com.google.gson.Gson;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.constant.SettingConstant;
import plus.hiver.common.entity.Setting;
import plus.hiver.common.service.SettingService;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.vo.OtherSetting;
import plus.hiver.module.system.vo.EmailSetting;
import plus.hiver.module.system.vo.NoticeSetting;
import plus.hiver.module.system.vo.OssSetting;
import plus.hiver.module.system.vo.SmsSetting;

@RestController
@Tag(name="\u57fa\u672c\u914d\u7f6e\u63a5\u53e3")
@PermissionTag(permission="setting:*")
@RequestMapping(value={"/hiver/setting"})
public class SettingController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SettingController.class);
    @Resource
    private SettingService settingService;

    @GetMapping(value={"/seeSecret/{settingName}"})
    @Operation(summary="\u67e5\u770b\u79c1\u5bc6\u914d\u7f6e")
    public Result seeSecret(@PathVariable String string) {
        String string2 = "";
        Setting setting = this.settingService.findByKey(string);
        if (setting == null || StrUtil.isBlank((CharSequence)setting.getValue())) {
            return ResultUtil.error((String)"\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        if (string.equals("ALI_OSS")) {
            string2 = ((OssSetting)new Gson().fromJson(setting.getValue(), OssSetting.class)).getSecretKey();
        } else if (string.equals("ALI_SMS")) {
            string2 = ((SmsSetting)new Gson().fromJson(setting.getValue(), SmsSetting.class)).getSecretKey();
        } else if (string.equals("EMAIL_SETTING")) {
            string2 = ((EmailSetting)new Gson().fromJson(setting.getValue(), EmailSetting.class)).getPassword();
        }
        return ResultUtil.data((Object)string2);
    }

    @GetMapping(value={"/oss/check"})
    @Operation(summary="\u68c0\u67e5OSS\u914d\u7f6e")
    public Result ossCheck() {
        Setting setting = this.settingService.findByKey("OSS_USED");
        if (setting == null || StrUtil.isBlank((CharSequence)setting.getValue())) {
            return ResultUtil.error((Integer)501, (String)"\u60a8\u8fd8\u672a\u914d\u7f6e\u7b2c\u4e09\u65b9OSS\u670d\u52a1");
        }
        return ResultUtil.data((Object)setting.getValue());
    }

    @GetMapping(value={"/sms/check"})
    @Operation(summary="\u68c0\u67e5\u77ed\u4fe1\u914d\u7f6e")
    public Result smsCheck() {
        Setting setting = this.settingService.findByKey("SMS_USED");
        if (setting == null || StrUtil.isBlank((CharSequence)setting.getValue())) {
            return ResultUtil.error((Integer)501, (String)"\u60a8\u8fd8\u672a\u914d\u7f6e\u7b2c\u4e09\u65b9\u77ed\u4fe1\u670d\u52a1");
        }
        return ResultUtil.data((Object)setting.getValue());
    }

    @GetMapping(value={"/oss/{serviceName}"})
    @Operation(summary="\u67e5\u770bOSS\u914d\u7f6e")
    public Result<OssSetting> oss(@PathVariable String string) {
        Setting setting = new Setting();
        if (string.equals("ALI_OSS") || string.equals("LOCAL_OSS")) {
            setting = this.settingService.findByKey("OSS_USED");
        }
        if (setting == null || StrUtil.isBlank((CharSequence)setting.getValue())) {
            return new ResultUtil().setData(null);
        }
        String string2 = this.settingService.findByKey(string).getValue();
        OssSetting ossSetting = (OssSetting)new Gson().fromJson(string2, OssSetting.class);
        ossSetting.setSecretKey("**********");
        return new ResultUtil().setData((Object)ossSetting);
    }

    @GetMapping(value={"/sms/{serviceName}"})
    @Operation(summary="\u67e5\u770b\u77ed\u4fe1\u914d\u7f6e")
    public Result<SmsSetting> sms(@PathVariable String string) {
        Setting setting = new Setting();
        if (string.equals("ALI_SMS")) {
            setting = this.settingService.findByKey(string);
        }
        if (setting == null || StrUtil.isBlank((CharSequence)setting.getValue())) {
            return new ResultUtil().setData(null);
        }
        SmsSetting smsSetting = (SmsSetting)new Gson().fromJson(setting.getValue(), SmsSetting.class);
        smsSetting.setSecretKey("**********");
        if (smsSetting.getType() != null) {
            Setting setting2 = this.settingService.findByKey(string + "_" + smsSetting.getType());
            smsSetting.setTemplateCode(setting2.getValue());
        }
        return new ResultUtil().setData((Object)smsSetting);
    }

    @GetMapping(value={"/sms/templateCodes/{serviceName}"})
    @Operation(summary="\u67e5\u770b\u77ed\u4fe1\u6a21\u677f\u914d\u7f6e")
    public Result smsTemplateCode(@PathVariable String string) {
        ArrayList arrayList = new ArrayList();
        for (SettingConstant.SMS_TYPE sMS_TYPE : SettingConstant.SMS_TYPE.values()) {
            Setting setting = this.settingService.findByKey(string + "_" + sMS_TYPE.name());
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string2 = "";
            if (StrUtil.isNotBlank((CharSequence)setting.getValue())) {
                string2 = setting.getValue();
            }
            hashMap.put("type", sMS_TYPE.name());
            hashMap.put("templateCode", string2);
            arrayList.add(hashMap);
        }
        return ResultUtil.data(arrayList);
    }

    @GetMapping(value={"/email"})
    @Operation(summary="\u67e5\u770bemail\u914d\u7f6e")
    public Result<EmailSetting> email() {
        Setting setting = this.settingService.findByKey("EMAIL_SETTING");
        if (setting == null || StrUtil.isBlank((CharSequence)setting.getValue())) {
            return new ResultUtil().setData(null);
        }
        EmailSetting emailSetting = (EmailSetting)new Gson().fromJson(setting.getValue(), EmailSetting.class);
        emailSetting.setPassword("**********");
        return new ResultUtil().setData((Object)emailSetting);
    }

    @GetMapping(value={"/other"})
    @Operation(summary="\u67e5\u770b\u5176\u4ed6\u914d\u7f6e")
    public Result<OtherSetting> other() {
        Setting setting = this.settingService.findByKey("OTHER_SETTING");
        if (setting == null || StrUtil.isBlank((CharSequence)setting.getValue())) {
            return new ResultUtil().setData(null);
        }
        OtherSetting otherSetting = (OtherSetting)new Gson().fromJson(setting.getValue(), OtherSetting.class);
        return new ResultUtil().setData((Object)otherSetting);
    }

    @GetMapping(value={"/notice"})
    @Operation(summary="\u67e5\u770b\u516c\u544a\u914d\u7f6e")
    public Result<NoticeSetting> notice() {
        Setting setting = this.settingService.findByKey("NOTICE_SETTING");
        if (setting == null || StrUtil.isBlank((CharSequence)setting.getValue())) {
            return new ResultUtil().setData(null);
        }
        NoticeSetting noticeSetting = (NoticeSetting)new Gson().fromJson(setting.getValue(), NoticeSetting.class);
        return new ResultUtil().setData((Object)noticeSetting);
    }

    @PostMapping(value={"/oss/set"})
    @Operation(summary="OSS\u914d\u7f6e")
    public Result ossSet(OssSetting ossSetting) {
        String string;
        String string2 = ossSetting.getServiceName();
        Setting setting = this.settingService.findByKey(string2);
        if (string2.equals("ALI_OSS") && StrUtil.isNotBlank((CharSequence)setting.getValue()) && !ossSetting.getChanged().booleanValue()) {
            string = ((OssSetting)new Gson().fromJson(setting.getValue(), OssSetting.class)).getSecretKey();
            ossSetting.setSecretKey(string);
        }
        setting.setValue(new Gson().toJson((Object)ossSetting));
        this.settingService.saveOrUpdate(setting);
        string = this.settingService.findByKey("OSS_USED");
        string.setValue(string2);
        this.settingService.saveOrUpdate((Setting)string);
        return ResultUtil.data(null);
    }

    @PostMapping(value={"/sms/set"})
    @Operation(summary="\u77ed\u4fe1\u914d\u7f6e")
    public Result smsSet(SmsSetting smsSetting) {
        String string;
        String string2 = smsSetting.getServiceName();
        Setting setting = this.settingService.findByKey(string2);
        if (string2.equals("ALI_SMS") && StrUtil.isNotBlank((CharSequence)setting.getValue()) && !smsSetting.getChanged().booleanValue()) {
            string = ((SmsSetting)new Gson().fromJson(setting.getValue(), SmsSetting.class)).getSecretKey();
            smsSetting.setSecretKey(string);
        }
        setting.setValue(new Gson().toJson((Object)smsSetting.setType(null).setTemplateCode(null)));
        this.settingService.saveOrUpdate(setting);
        string = this.settingService.findByKey("SMS_USED");
        string.setValue(string2);
        this.settingService.saveOrUpdate((Setting)string);
        return ResultUtil.data(null);
    }

    @PostMapping(value={"/sms/templateCode/set"})
    @Operation(summary="\u77ed\u4fe1\u914d\u7f6e")
    public Result smsTemplateCodeSet(SmsSetting smsSetting) {
        if (StrUtil.isNotBlank((CharSequence)smsSetting.getServiceName()) && StrUtil.isNotBlank((CharSequence)smsSetting.getType())) {
            Setting setting = this.settingService.findByKey(smsSetting.getServiceName() + "_" + smsSetting.getType());
            setting.setValue(smsSetting.getTemplateCode());
            this.settingService.saveOrUpdate(setting);
        }
        return ResultUtil.success();
    }

    @PostMapping(value={"/email/set"})
    @Operation(summary="email\u914d\u7f6e")
    public Result emailSet(EmailSetting emailSetting) {
        Setting setting = this.settingService.findByKey("EMAIL_SETTING");
        if (StrUtil.isNotBlank((CharSequence)setting.getValue()) && !emailSetting.getChanged().booleanValue()) {
            String string = ((EmailSetting)new Gson().fromJson(setting.getValue(), EmailSetting.class)).getPassword();
            emailSetting.setPassword(string);
        }
        setting.setValue(new Gson().toJson((Object)emailSetting));
        this.settingService.saveOrUpdate(setting);
        return ResultUtil.data(null);
    }

    @PostMapping(value={"/other/set"})
    @Operation(summary="\u5176\u4ed6\u914d\u7f6e")
    public Result otherSet(OtherSetting otherSetting) {
        Setting setting = this.settingService.findByKey("OTHER_SETTING");
        setting.setValue(new Gson().toJson((Object)otherSetting));
        this.settingService.saveOrUpdate(setting);
        return ResultUtil.data(null);
    }

    @PostMapping(value={"/notice/set"})
    @Operation(summary="\u516c\u544a\u914d\u7f6e")
    public Result noticeSet(NoticeSetting noticeSetting) {
        Setting setting = this.settingService.findByKey("NOTICE_SETTING");
        setting.setValue(new Gson().toJson((Object)noticeSetting));
        this.settingService.saveOrUpdate(setting);
        return ResultUtil.data(null);
    }

    @Generated
    public SettingController(SettingService settingService) {
        this.settingService = settingService;
    }
}

