/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.system.serviceimpl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import jakarta.annotation.Nullable;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import plus.hiver.common.base.HiverBaseDao;
import plus.hiver.common.base.HiverBaseServiceImpl;
import plus.hiver.common.vo.SearchVo;
import plus.hiver.module.system.dao.MessageDao;
import plus.hiver.module.system.entity.Message;
import plus.hiver.module.system.service.MessageService;

@Service
@Transactional
public class MessageServiceImpl
extends HiverBaseServiceImpl<Message, Long, MessageDao>
implements MessageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageServiceImpl.class);

    public MessageServiceImpl(MessageDao messageDao) {
        super((HiverBaseDao)messageDao);
    }

    @Override
    public Page<Message> findByCondition(final Message message, final SearchVo searchVo, Pageable pageable) {
        return ((MessageDao)this.dao).findAll((Specification)new Specification<Message>(){

            @Nullable
            public Predicate toPredicate(Root<Message> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                DateTime dateTime;
                Path path = root.get("title");
                Path path2 = root.get("content");
                Path path3 = root.get("type");
                Path path4 = root.get("isTemplate");
                Path path5 = root.get("createTime");
                ArrayList<Predicate> arrayList = new ArrayList<Predicate>();
                if (StrUtil.isNotBlank((CharSequence)message.getTitle())) {
                    arrayList.add(criteriaBuilder.like((Expression)path, "%" + message.getTitle() + "%"));
                }
                if (StrUtil.isNotBlank((CharSequence)message.getContent())) {
                    arrayList.add(criteriaBuilder.like((Expression)path2, "%" + message.getContent() + "%"));
                }
                if (message.getType() != null) {
                    arrayList.add(criteriaBuilder.equal((Expression)path3, (Object)message.getType()));
                }
                if (message.getIsTemplate() != null) {
                    arrayList.add(criteriaBuilder.equal((Expression)path4, (Object)message.getIsTemplate()));
                }
                if (StrUtil.isNotBlank((CharSequence)searchVo.getStartDate()) && StrUtil.isNotBlank((CharSequence)searchVo.getEndDate())) {
                    dateTime = DateUtil.parse((CharSequence)searchVo.getStartDate());
                    DateTime dateTime2 = DateUtil.parse((CharSequence)searchVo.getEndDate());
                    arrayList.add(criteriaBuilder.between((Expression)path5, (Comparable)dateTime, (Comparable)DateUtil.endOfDay((Date)dateTime2)));
                }
                dateTime = new Predicate[arrayList.size()];
                criteriaQuery.where(arrayList.toArray((T[])dateTime));
                return null;
            }
        }, pageable);
    }

    @Override
    public List<Message> findByCreateSend(Boolean bl) {
        return ((MessageDao)this.dao).findByCreateSend(bl);
    }
}

