/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.system.async;

import jakarta.annotation.Resource;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import plus.hiver.module.system.entity.Message;
import plus.hiver.module.system.entity.MessageSend;
import plus.hiver.module.system.service.MessageSendService;
import plus.hiver.module.system.service.MessageService;

import java.util.ArrayList;
import java.util.List;

/**
 * 异步添加消息
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Slf4j
@Component
@AllArgsConstructor
public class AddMessage {
    @Resource
    private MessageService messageService;

    @Resource
    private MessageSendService messageSendService;

    /**
     * 初始化消息
     *
     * @param userId
     */
    @Async
    public void addSendMessage(Long userId) {
        // 获取需要创建账号发送的消息
        List<Message> messages = messageService.findByCreateSend(true);
        List<MessageSend> messageSends = new ArrayList<>();
        messages.forEach(item -> {
            MessageSend ms = new MessageSend();
            ms.setUserId(userId);
            ms.setMessageId(item.getId());
            messageSends.add(ms);
        });
        messageSendService.saveOrUpdateAll(messageSends);
    }
}
