/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.system.controller;

import cn.hutool.http.HttpUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.utils.ResultUtil;

import java.util.HashMap;
import java.util.Map;

/**
 * Security相关接口
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Slf4j
@RestController
@AllArgsConstructor
@Tag(name = "Security相关接口")
@PermissionTag(permission = "common:*" )
@RequestMapping("/hiver/common")
@Transactional
public class SecurityController {
    @GetMapping(value = "/needLogin")
    @Operation(summary = "没有登录")
    public Result needLogin() {
        return ResultUtil.error(401, "您还未登录");
    }

    @GetMapping(value = "/swagger/login")
    @Operation(summary = "Swagger接口文档专用登录接口 方便测试")
    public Result swaggerLogin(@RequestParam String username, @RequestParam String password,
                               @Parameter(name = "记住密码") @RequestParam(required = false, defaultValue = "true") Boolean saveLogin,
                               @Parameter(name = "可自定义登录接口地址")
                               @RequestParam(required = false, defaultValue = "http://127.0.0.1:8888/hiver/login")
                               String loginUrl) {
        Map<String, Object> params = new HashMap<>(16);
        params.put("username", username);
        params.put("password", password);
        params.put("saveLogin", saveLogin);
        String result = HttpUtil.post(loginUrl, params);
        return ResultUtil.data(result);
    }
}
