/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.system.controller;

import cn.hutool.core.util.IdUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.redis.RedisTemplateHelper;
import plus.hiver.common.utils.CreateVerifyCode;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.utils.StringUtil;

@RestController
@Tag(name="\u9a8c\u8bc1\u7801\u63a5\u53e3")
@PermissionTag(permission="common:captcha:*")
@RequestMapping(value={"/hiver/common/captcha"})
public class CaptchaController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CaptchaController.class);
    @Resource
    private RedisTemplateHelper redisTemplateHelper;

    @GetMapping(value={"/init"})
    @Operation(summary="\u521d\u59cb\u5316\u9a8c\u8bc1\u7801")
    public Result initCaptcha(@Parameter(name="\u4ec5\u751f\u6210\u6570\u5b57") @RequestParam(required=false, defaultValue="false") Boolean bl, @Parameter(name="\u9a8c\u8bc1\u7801\u957f\u5ea6") @RequestParam(required=false, defaultValue="4") Integer n) {
        String string = IdUtil.simpleUUID();
        String string2 = bl != false ? StringUtil.randomDigit((int)n) : StringUtil.randomStr((int)n);
        this.redisTemplateHelper.set(string, string2, 2L, TimeUnit.MINUTES);
        return ResultUtil.data((Object)string);
    }

    @GetMapping(value={"/draw/{captchaId}"})
    @Operation(summary="\u6839\u636e\u9a8c\u8bc1\u7801ID\u83b7\u53d6\u56fe\u7247")
    public void drawCaptcha(@PathVariable(value="captchaId") String string, HttpServletResponse httpServletResponse) throws IOException {
        String string2 = this.redisTemplateHelper.get(string);
        CreateVerifyCode createVerifyCode = new CreateVerifyCode(116, 36, 4, 10, string2);
        httpServletResponse.setContentType("image/png");
        createVerifyCode.write((OutputStream)httpServletResponse.getOutputStream());
    }

    @Generated
    public CaptchaController(RedisTemplateHelper redisTemplateHelper) {
        this.redisTemplateHelper = redisTemplateHelper;
    }
}

