/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.system.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.base.HiverBaseEntity;
import plus.hiver.common.constant.HiverConstant;
import plus.hiver.common.entity.Role;
import plus.hiver.common.entity.RoleDepartment;
import plus.hiver.common.entity.RolePermission;
import plus.hiver.common.redis.RedisTemplateHelper;
import plus.hiver.common.service.RoleDepartmentService;
import plus.hiver.common.service.RolePermissionService;
import plus.hiver.common.service.RoleService;
import plus.hiver.common.service.UserRoleService;
import plus.hiver.common.utils.PageUtil;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.vo.PageVo;

@RestController
@Tag(name="\u89d2\u8272\u7ba1\u7406\u63a5\u53e3")
@PermissionTag(permission="role:*")
@RequestMapping(value={"/hiver/role"})
@Transactional
public class RoleController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RoleController.class);
    @Resource
    private RoleService roleService;
    @Resource
    private UserRoleService userRoleService;
    @Resource
    private RolePermissionService rolePermissionService;
    @Resource
    private RoleDepartmentService roleDepartmentService;
    @Resource
    private RedisTemplateHelper redisTemplateHelper;

    @GetMapping(value={"/getAllList"})
    @Operation(summary="\u83b7\u53d6\u5168\u90e8\u89d2\u8272")
    public Result roleGetAll() {
        List list = this.roleService.getAll();
        return ResultUtil.data((Object)list);
    }

    @GetMapping(value={"/getAllByPage"})
    @Operation(summary="\u5206\u9875\u83b7\u53d6\u89d2\u8272")
    public Result<Page<Role>> getRoleByPage(String string, PageVo pageVo) {
        Page page = this.roleService.findByCondition(string, PageUtil.initPage((PageVo)pageVo));
        for (Role role : page.getContent()) {
            List list = this.rolePermissionService.findByRoleId(role.getId());
            role.setPermissions(list);
            List list2 = this.roleDepartmentService.findByRoleId(role.getId());
            role.setDepartments(list2);
        }
        return new ResultUtil().setData((Object)page);
    }

    @PostMapping(value={"/setDefault"})
    @Operation(summary="\u8bbe\u7f6e\u6216\u53d6\u6d88\u9ed8\u8ba4\u89d2\u8272")
    public Result setDefault(@RequestParam Long l, @RequestParam Boolean bl) {
        Role role = (Role)this.roleService.get(l);
        if (role == null) {
            return ResultUtil.error((String)"\u89d2\u8272\u4e0d\u5b58\u5728");
        }
        role.setDefaultRole(bl);
        this.roleService.update((HiverBaseEntity)role);
        return ResultUtil.success((String)"\u8bbe\u7f6e\u6210\u529f");
    }

    @PostMapping(value={"/editRolePerm"})
    @Operation(summary="\u7f16\u8f91\u89d2\u8272\u5206\u914d\u83dc\u5355\u6743\u9650")
    public Result editRolePerm(@RequestParam Long l, @RequestParam(required=false) Long[] longArray) {
        this.rolePermissionService.deleteByRoleId(l);
        if (longArray != null) {
            List list = Arrays.asList(longArray).stream().map(l2 -> new RolePermission().setRoleId(l).setPermissionId(l2)).collect(Collectors.toList());
            this.rolePermissionService.saveOrUpdateAll(list);
        }
        this.redisTemplateHelper.deleteByPattern("user:*");
        this.redisTemplateHelper.deleteByPattern("userRole:*");
        this.redisTemplateHelper.deleteByPattern("permission::userMenuList:*");
        return ResultUtil.data(null);
    }

    @PostMapping(value={"/editRoleDep"})
    @Operation(summary="\u7f16\u8f91\u89d2\u8272\u5206\u914d\u6570\u636e\u6743\u9650")
    public Result editRoleDep(@RequestParam Long l, @RequestParam Integer n, @RequestParam(required=false) Long[] longArray) {
        Role role = (Role)this.roleService.get(l);
        role.setDataType(n);
        this.roleService.update((HiverBaseEntity)role);
        if (HiverConstant.DATA_TYPE_CUSTOM.equals(n)) {
            this.roleDepartmentService.deleteByRoleId(l);
            if (longArray != null) {
                List list = Arrays.asList(longArray).stream().map(l2 -> new RoleDepartment().setRoleId(l).setDepartmentId(l2)).collect(Collectors.toList());
                this.roleDepartmentService.saveOrUpdateAll(list);
            }
        }
        this.redisTemplateHelper.deleteByPattern("department:*");
        this.redisTemplateHelper.deleteByPattern("userRole:*");
        return ResultUtil.data(null);
    }

    @PostMapping(value={"/save"})
    @Operation(summary="\u4fdd\u5b58\u6570\u636e")
    public Result<Role> save(@RequestBody Role role) {
        Role role2 = (Role)this.roleService.save((HiverBaseEntity)role);
        return new ResultUtil().setData((Object)role2);
    }

    @PostMapping(value={"/edit"})
    @Operation(summary="\u66f4\u65b0\u6570\u636e")
    public Result<Role> edit(@RequestBody Role role) {
        Role role2 = (Role)this.roleService.update((HiverBaseEntity)role);
        this.redisTemplateHelper.deleteByPattern("user:*");
        this.redisTemplateHelper.deleteByPattern("userRole:*");
        return new ResultUtil().setData((Object)role2);
    }

    @PostMapping(value={"/delByIds"})
    @Operation(summary="\u6279\u91cf\u901a\u8fc7ids\u5220\u9664")
    public Result delByIds(@RequestParam Long[] longArray) {
        for (Long l : longArray) {
            List list = this.userRoleService.findByRoleId(l);
            if (list == null || list.size() <= 0) continue;
            return ResultUtil.error((String)"\u5220\u9664\u5931\u8d25\uff0c\u5305\u542b\u6b63\u88ab\u7528\u6237\u4f7f\u7528\u5173\u8054\u7684\u89d2\u8272");
        }
        for (Long l : longArray) {
            this.roleService.delete(l);
            this.rolePermissionService.deleteByRoleId(l);
            this.roleDepartmentService.deleteByRoleId(l);
        }
        return ResultUtil.success((String)"\u6279\u91cf\u901a\u8fc7id\u5220\u9664\u6570\u636e\u6210\u529f");
    }

    @Generated
    public RoleController(RoleService roleService, UserRoleService userRoleService, RolePermissionService rolePermissionService, RoleDepartmentService roleDepartmentService, RedisTemplateHelper redisTemplateHelper) {
        this.roleService = roleService;
        this.userRoleService = userRoleService;
        this.rolePermissionService = rolePermissionService;
        this.roleDepartmentService = roleDepartmentService;
        this.redisTemplateHelper = redisTemplateHelper;
    }
}

