/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.system.controller;

import cn.hutool.core.util.StrUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.base.HiverBaseEntity;
import plus.hiver.common.constant.HiverConstant;
import plus.hiver.common.entity.Department;
import plus.hiver.common.entity.DepartmentHeader;
import plus.hiver.common.entity.User;
import plus.hiver.common.exception.HiverException;
import plus.hiver.common.redis.RedisTemplateHelper;
import plus.hiver.common.service.DepartmentHeaderService;
import plus.hiver.common.service.DepartmentService;
import plus.hiver.common.service.RoleDepartmentService;
import plus.hiver.common.service.UserService;
import plus.hiver.common.utils.CommonUtil;
import plus.hiver.common.utils.HibernateProxyTypeAdapter;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.utils.SecurityUtil;

@RestController
@Tag(name="\u90e8\u95e8\u7ba1\u7406\u63a5\u53e3")
@PermissionTag(permission="department:*")
@RequestMapping(value={"/hiver/department"})
@CacheConfig(cacheNames={"department"})
@Transactional
public class DepartmentController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DepartmentController.class);
    @Resource
    private DepartmentService departmentService;
    @Resource
    private UserService userService;
    @Resource
    private RoleDepartmentService roleDepartmentService;
    @Resource
    private DepartmentHeaderService departmentHeaderService;
    @Resource
    private SecurityUtil securityUtil;
    @Resource
    private RedisTemplateHelper redisTemplateHelper;

    @GetMapping(value={"/getByParentId/{parentId}"})
    @Operation(summary="\u901a\u8fc7parentId\u83b7\u53d6")
    public Result<List<Department>> getByParentId(@PathVariable Long l, @RequestParam(required=false, defaultValue="true") Boolean bl) {
        User user = this.securityUtil.getCurrUser();
        String string = "department::" + l + ":" + user.getId() + "_" + bl;
        String string2 = this.redisTemplateHelper.get(string);
        if (StrUtil.isNotBlank((CharSequence)string2)) {
            List list = (List)new Gson().fromJson(string2, new TypeToken<List<Department>>(){}.getType());
            return new ResultUtil().setData((Object)list);
        }
        List list = this.departmentService.findByParentIdOrderBySortOrder(l, bl);
        this.setInfo(list);
        this.redisTemplateHelper.set(string, new GsonBuilder().registerTypeAdapterFactory(HibernateProxyTypeAdapter.FACTORY).create().toJson((Object)list), 15L, TimeUnit.DAYS);
        return new ResultUtil().setData((Object)list);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u6dfb\u52a0")
    public Result add(@RequestBody Department department) {
        Department department2;
        Department department3 = (Department)this.departmentService.save((HiverBaseEntity)department);
        if (!("0".equals(department.getParentId().toString()) || (department2 = (Department)this.departmentService.get(department.getParentId())).getIsParent() != null && department2.getIsParent().booleanValue())) {
            department2.setIsParent(Boolean.valueOf(true));
            this.departmentService.update((HiverBaseEntity)department2);
        }
        this.redisTemplateHelper.deleteByPattern("department::*");
        this.redisTemplateHelper.deleteByPattern("userRole::depIds:*");
        return ResultUtil.success((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @PostMapping(value={"/edit"})
    @Operation(summary="\u7f16\u8f91")
    public Result edit(@RequestBody Department department, @RequestParam(required=false) Long[] department2, @RequestParam(required=false) Long[] longArray) {
        DepartmentHeader departmentHeader;
        if (department.getId().equals(department.getParentId())) {
            return ResultUtil.error((String)"\u4e0a\u7ea7\u8282\u70b9\u4e0d\u80fd\u4e3a\u81ea\u5df1");
        }
        Department department3 = (Department)this.departmentService.get(department.getId());
        Long l = department3.getParentId();
        String string = department3.getTitle();
        Department department4 = (Department)this.departmentService.update((HiverBaseEntity)department);
        this.departmentHeaderService.deleteByDepartmentId(department.getId());
        ArrayList<DepartmentHeader> arrayList = new ArrayList<DepartmentHeader>();
        if (department2 != null) {
            for (Long l2 : department2) {
                departmentHeader = new DepartmentHeader();
                departmentHeader.setUserId(l2);
                departmentHeader.setDepartmentId(department4.getId());
                departmentHeader.setType(HiverConstant.HEADER_TYPE_MAIN);
                arrayList.add(departmentHeader);
            }
        }
        if (longArray != null) {
            for (Long l2 : longArray) {
                departmentHeader = new DepartmentHeader();
                departmentHeader.setUserId(l2);
                departmentHeader.setDepartmentId(department4.getId());
                departmentHeader.setType(HiverConstant.HEADER_TYPE_VICE);
                arrayList.add(departmentHeader);
            }
        }
        this.departmentHeaderService.saveOrUpdateAll(arrayList);
        if (!"0".equals(l.toString()) && !l.equals(department.getParentId())) {
            Department department5 = (Department)this.departmentService.get(l);
            List list = this.departmentService.findByParentIdOrderBySortOrder(department5.getId(), Boolean.valueOf(false));
            if (department5 != null && (list == null || list.isEmpty())) {
                department5.setIsParent(Boolean.valueOf(false));
                this.departmentService.update((HiverBaseEntity)department5);
            }
        }
        if (!string.equals(department.getTitle())) {
            this.userService.updateDepartmentTitle(department.getId(), department.getTitle());
            this.redisTemplateHelper.deleteByPattern("user:*");
        }
        this.redisTemplateHelper.deleteByPattern("department:*");
        return ResultUtil.success((String)"\u7f16\u8f91\u6210\u529f");
    }

    @PostMapping(value={"/delByIds"})
    @Operation(summary="\u6279\u91cf\u901a\u8fc7id\u5220\u9664")
    public Result delByIds(@RequestParam Long[] longArray) {
        for (Long l : longArray) {
            this.deleteRecursion(l, longArray);
        }
        this.redisTemplateHelper.deleteByPattern("department:*");
        this.redisTemplateHelper.deleteByPattern("userRole::depIds:*");
        return ResultUtil.success((String)"\u6279\u91cf\u901a\u8fc7id\u5220\u9664\u6570\u636e\u6210\u529f");
    }

    public void deleteRecursion(Long l, Long[] longArray) {
        List list;
        List list2 = this.userService.findByDepartmentId(l);
        if (list2 != null && list2.size() > 0) {
            throw new HiverException("\u5220\u9664\u5931\u8d25\uff0c\u5305\u542b\u6b63\u88ab\u7528\u6237\u4f7f\u7528\u5173\u8054\u7684\u90e8\u95e8");
        }
        Department department = (Department)this.departmentService.get(l);
        Department department2 = (Department)this.departmentService.findById(department.getParentId());
        this.departmentService.delete(l);
        this.roleDepartmentService.deleteByDepartmentId(l);
        this.departmentHeaderService.deleteByDepartmentId(l);
        if (department2 != null && ((list = this.departmentService.findByParentIdOrderBySortOrder(department2.getId(), Boolean.valueOf(false))) == null || list.isEmpty())) {
            department2.setIsParent(Boolean.valueOf(false));
            this.departmentService.update((HiverBaseEntity)department2);
        }
        list = this.departmentService.findByParentIdOrderBySortOrder(l, Boolean.valueOf(false));
        for (Department department3 : list) {
            if (CommonUtil.judgeIds((Long)department3.getId(), (Long[])longArray).booleanValue()) continue;
            this.deleteRecursion(department3.getId(), longArray);
        }
    }

    @GetMapping(value={"/search"})
    @Operation(summary="\u90e8\u95e8\u540d\u6a21\u7cca\u641c\u7d22")
    public Result<List<Department>> searchByTitle(@RequestParam String string, @RequestParam(required=false, defaultValue="true") Boolean bl) {
        List list = this.departmentService.findByTitleLikeOrderBySortOrder("%" + string + "%", bl);
        this.setInfo(list);
        return new ResultUtil().setData((Object)list);
    }

    public void setInfo(List<Department> list) {
        list.forEach(department -> {
            if (!"0".equals(department.getParentId().toString())) {
                Department department2 = (Department)this.departmentService.get(department.getParentId());
                department.setParentTitle(department2.getTitle());
            } else {
                department.setParentTitle("\u4e00\u7ea7\u90e8\u95e8");
            }
            department.setMainHeaders(this.departmentHeaderService.findHeaderByDepartmentId(department.getId(), HiverConstant.HEADER_TYPE_MAIN));
            department.setViceHeaders(this.departmentHeaderService.findHeaderByDepartmentId(department.getId(), HiverConstant.HEADER_TYPE_VICE));
        });
    }

    @Generated
    public DepartmentController(DepartmentService departmentService, UserService userService, RoleDepartmentService roleDepartmentService, DepartmentHeaderService departmentHeaderService, SecurityUtil securityUtil, RedisTemplateHelper redisTemplateHelper) {
        this.departmentService = departmentService;
        this.userService = userService;
        this.roleDepartmentService = roleDepartmentService;
        this.departmentHeaderService = departmentHeaderService;
        this.securityUtil = securityUtil;
        this.redisTemplateHelper = redisTemplateHelper;
    }
}

