/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.system.controller;

import com.google.gson.Gson;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.ibatis.annotations.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.base.HiverBaseController;
import plus.hiver.common.constant.MessageConstant;
import plus.hiver.common.entity.User;
import plus.hiver.common.service.UserService;
import plus.hiver.common.utils.PageUtil;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.utils.SecurityUtil;
import plus.hiver.common.vo.PageVo;
import plus.hiver.module.system.entity.Message;
import plus.hiver.module.system.entity.MessageSend;
import plus.hiver.module.system.service.MessageSendService;
import plus.hiver.module.system.service.MessageService;

@RestController
@Tag(name="\u6d88\u606f\u53d1\u9001\u7ba1\u7406\u63a5\u53e3")
@PermissionTag(permission="messageSend:*")
@RequestMapping(value={"/hiver/messageSend"})
@Transactional
public class MessageSendController
extends HiverBaseController<MessageSend, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageSendController.class);
    @Resource
    private UserService userService;
    @Resource
    private MessageService messageService;
    @Resource
    private MessageSendService messageSendService;
    @Resource
    private SecurityUtil securityUtil;

    public MessageSendService getService() {
        return this.messageSendService;
    }

    @GetMapping(value={"/getByCondition"})
    @Operation(summary="\u591a\u6761\u4ef6\u5206\u9875\u83b7\u53d6")
    public Result<Page<MessageSend>> getByCondition(MessageSend messageSend2, PageVo pageVo) {
        Page<MessageSend> page = this.messageSendService.findByCondition(messageSend2, PageUtil.initPage((PageVo)pageVo));
        page.getContent().forEach(messageSend -> {
            Message message;
            User user = (User)this.userService.findById(messageSend.getUserId());
            if (user != null) {
                messageSend.setUsername(user.getUsername());
                messageSend.setNickname(user.getNickname());
            }
            if ((message = (Message)this.messageService.findById(messageSend.getMessageId())) != null) {
                if (message.getIsTemplate().booleanValue()) {
                    Message message2 = this.messageSendService.getTemplateMessage(messageSend.getMessageId(), (Map)new Gson().fromJson(messageSend.getParams(), HashMap.class));
                    messageSend.setTitle(message2.getTitle());
                    messageSend.setContent(message2.getContent());
                    messageSend.setType(message.getType());
                } else {
                    messageSend.setTitle(message.getTitle());
                    messageSend.setContent(message.getContent());
                    messageSend.setType(message.getType());
                }
            }
        });
        return new ResultUtil().setData(page);
    }

    @GetMapping(value={"/all/{type}"})
    @Operation(summary="\u591a\u6761\u4ef6\u5206\u9875\u83b7\u53d6")
    public Result batchOperation(@Param(value="0\u5168\u90e8\u5df2\u8bfb 1\u5168\u90e8\u5220\u9664\u5df2\u8bfb") @PathVariable Integer n) {
        User user = this.securityUtil.getCurrUser();
        if (n == 0) {
            this.messageSendService.updateStatusByUserId(user.getId(), MessageConstant.MESSAGE_STATUS_READ);
        } else if (n == 1) {
            this.messageSendService.deleteByUserId(user.getId());
        }
        return ResultUtil.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/edit"})
    @Operation(summary="\u7f16\u8f91")
    public Result edit(@RequestBody MessageSend messageSend) {
        if (this.messageService.findById(messageSend.getMessageId()) != null) {
            this.messageSendService.update(messageSend);
        }
        return ResultUtil.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @Generated
    public MessageSendController(UserService userService, MessageService messageService, MessageSendService messageSendService, SecurityUtil securityUtil) {
        this.userService = userService;
        this.messageService = messageService;
        this.messageSendService = messageSendService;
        this.securityUtil = securityUtil;
    }
}

