/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.system.serviceimpl;

import cn.hutool.core.util.StrUtil;
import jakarta.annotation.Nullable;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import plus.hiver.common.base.HiverBaseDao;
import plus.hiver.common.base.HiverBaseServiceImpl;
import plus.hiver.common.constant.HiverConstant;
import plus.hiver.module.system.dao.DictDataDao;
import plus.hiver.module.system.entity.DictData;
import plus.hiver.module.system.service.DictDataService;

@Service
@Transactional
public class DictDataServiceImpl
extends HiverBaseServiceImpl<DictData, Long, DictDataDao>
implements DictDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DictDataServiceImpl.class);

    public DictDataServiceImpl(DictDataDao dictDataDao) {
        super((HiverBaseDao)dictDataDao);
    }

    @Override
    public Page<DictData> findByCondition(final DictData dictData, Pageable pageable) {
        return ((DictDataDao)this.dao).findAll((Specification)new Specification<DictData>(){

            @Nullable
            public Predicate toPredicate(Root<DictData> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                Path path = root.get("title");
                Path path2 = root.get("status");
                Path path3 = root.get("dictId");
                ArrayList<Predicate> arrayList = new ArrayList<Predicate>();
                if (StrUtil.isNotBlank((CharSequence)dictData.getTitle())) {
                    arrayList.add(criteriaBuilder.like((Expression)path, "%" + dictData.getTitle() + "%"));
                }
                if (dictData.getStatus() != null) {
                    arrayList.add(criteriaBuilder.equal((Expression)path2, (Object)dictData.getStatus()));
                }
                if (dictData.getDictId() != null && dictData.getDictId() > 0L) {
                    arrayList.add(criteriaBuilder.equal((Expression)path3, (Object)dictData.getDictId()));
                }
                Predicate[] predicateArray = new Predicate[arrayList.size()];
                criteriaQuery.where(arrayList.toArray(predicateArray));
                return null;
            }
        }, pageable);
    }

    @Override
    public List<DictData> findByDictId(Long l) {
        return ((DictDataDao)this.dao).findByDictIdAndStatusOrderBySortOrder(l, HiverConstant.STATUS_NORMAL);
    }

    @Override
    public void deleteByDictId(Long l) {
        ((DictDataDao)this.dao).deleteByDictId(l);
    }

    @Override
    public DictData findByDictIdAndValue(Long l, String string) {
        return ((DictDataDao)this.dao).findByDictIdAndValue(l, string);
    }
}

