/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.system.serviceimpl;

import com.google.gson.Gson;
import jakarta.annotation.Nullable;
import jakarta.annotation.Resource;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Service;
import plus.hiver.common.base.HiverBaseDao;
import plus.hiver.common.base.HiverBaseServiceImpl;
import plus.hiver.common.constant.MessageConstant;
import plus.hiver.common.exception.HiverException;
import plus.hiver.module.system.dao.MessageDao;
import plus.hiver.module.system.dao.MessageSendDao;
import plus.hiver.module.system.entity.Message;
import plus.hiver.module.system.entity.MessageSend;
import plus.hiver.module.system.service.MessageSendService;

@Service
@Transactional
public class MessageSendServiceImpl
extends HiverBaseServiceImpl<MessageSend, Long, MessageSendDao>
implements MessageSendService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageSendServiceImpl.class);
    @Resource
    private MessageDao messageDao;
    @Resource
    private SimpMessagingTemplate messagingTemplate;

    public MessageSendServiceImpl(MessageSendDao messageSendDao) {
        super((HiverBaseDao)messageSendDao);
    }

    @Override
    public MessageSend send(MessageSend messageSend) {
        MessageSend messageSend2 = (MessageSend)((Object)((MessageSendDao)this.dao).save((Object)messageSend));
        this.messagingTemplate.convertAndSendToUser(messageSend.getUserId().toString(), "/queue/subscribe", (Object)"\u60a8\u6536\u5230\u4e86\u65b0\u7684\u6d88\u606f");
        return messageSend2;
    }

    @Override
    public void deleteByMessageId(Long l) {
        ((MessageSendDao)this.dao).deleteByMessageId(l);
    }

    @Override
    public Page<MessageSend> findByCondition(final MessageSend messageSend, Pageable pageable) {
        return ((MessageSendDao)this.dao).findAll((Specification)new Specification<MessageSend>(){

            @Nullable
            public Predicate toPredicate(Root<MessageSend> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                Path path = root.get("messageId");
                Path path2 = root.get("userId");
                Path path3 = root.get("status");
                ArrayList<Predicate> arrayList = new ArrayList<Predicate>();
                if (messageSend != null && messageSend.getMessageId() != null && messageSend.getMessageId() > 0L) {
                    arrayList.add(criteriaBuilder.equal((Expression)path, (Object)messageSend.getMessageId()));
                }
                if (messageSend != null && messageSend.getUserId() > 0L) {
                    arrayList.add(criteriaBuilder.equal((Expression)path2, (Object)messageSend.getUserId()));
                }
                if (messageSend != null && messageSend.getStatus() != null) {
                    arrayList.add(criteriaBuilder.equal((Expression)path3, (Object)messageSend.getStatus()));
                }
                Predicate[] predicateArray = new Predicate[arrayList.size()];
                criteriaQuery.where(arrayList.toArray(predicateArray));
                return null;
            }
        }, pageable);
    }

    @Override
    public void updateStatusByUserId(Long l, Integer n) {
        ((MessageSendDao)this.dao).updateStatusByUserId(l, n);
    }

    @Override
    public void deleteByUserId(Long l) {
        ((MessageSendDao)this.dao).deleteByUserId(l, MessageConstant.MESSAGE_STATUS_READ);
    }

    @Override
    public Message getTemplateMessage(Long l, Map<String, String> map) {
        Message message = this.messageDao.findById(l).orElse(null);
        if (message == null) {
            throw new HiverException("\u6d88\u606fID\uff1a" + l + "\u4e0d\u5b58\u5728");
        }
        Message message2 = new Message();
        message2.setTitle(this.changeParams(message.getTitle(), map));
        message2.setContent(this.changeParams(message.getContent(), map));
        return message2;
    }

    @Override
    public void sendTemplateMessage(List<Long> list, Long l, Map<String, String> map) {
        Message message = this.messageDao.findById(l).orElse(null);
        if (message == null) {
            throw new HiverException("\u6d88\u606fID\uff1a" + l + "\u4e0d\u5b58\u5728");
        }
        ArrayList<MessageSend> arrayList = new ArrayList<MessageSend>();
        for (Long l2 : list) {
            MessageSend messageSend = new MessageSend();
            messageSend.setUserId(l2);
            messageSend.setMessageId(l);
            messageSend.setTitle(this.changeParams(message.getTitle(), map));
            messageSend.setContent(this.changeParams(message.getContent(), map));
            messageSend.setParams(new Gson().toJson(map));
            arrayList.add(messageSend);
            this.messagingTemplate.convertAndSendToUser(l2.toString(), "/queue/subscribe", (Object)"\u60a8\u6536\u5230\u4e86\u65b0\u7684\u6d88\u606f");
        }
        ((MessageSendDao)this.dao).saveAll(arrayList);
    }

    @Override
    public void sendTemplateMessage(Long l, Long l2, Map<String, String> map) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        arrayList.add(l);
        this.sendTemplateMessage(arrayList, l2, map);
    }

    public String changeParams(String string, Map<String, String> map) {
        if (string == null) {
            return "";
        }
        if (map == null) {
            return string;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string2 = entry.getKey().toString();
            String string3 = entry.getValue().toString();
            string = string.replaceAll("\\$\\{" + string2 + "\\}", string3);
        }
        return string;
    }
}

