/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.system.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import lombok.*;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import plus.hiver.common.base.HiverBaseEntity;

import java.math.BigDecimal;

/**
 * 字典目录实体类
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Table(name = "t_dict")
@TableName("t_dict")
@Tag(name = "字典")
public class Dict extends HiverBaseEntity {
    private static final long serialVersionUID = 1L;

    @Schema(description = "字典名称")
    private String title;

    @Schema(description = "字典类型")
    private String type;

    @Schema(description = "备注")
    private String description;

    @Schema(description = "排序值")
    @Column(precision = 10, scale = 2)
    private BigDecimal sortOrder;
}
