/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.system.service;

import plus.hiver.common.base.HiverBaseService;
import plus.hiver.module.system.entity.Dict;

import java.util.List;

/**
 * 字典目录接口
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface DictService extends HiverBaseService<Dict, Long> {
    /**
     * 排序获取全部
     *
     * @return 字典列表
     */
    List<Dict> findAllOrderBySortOrder();

    /**
     * 通过type获取
     *
     * @param type 字典类型
     * @return 字典信息
     */
    Dict findByType(String type);

    /**
     * 模糊搜索
     *
     * @param key 关键字
     * @return 字典列表
     */
    List<Dict> findByTitleOrTypeLike(String key);
}
