/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.system.service;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import plus.hiver.common.base.HiverBaseService;
import plus.hiver.module.system.entity.Message;
import plus.hiver.module.system.entity.MessageSend;

import java.util.List;
import java.util.Map;

/**
 * 消息发送接口
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface MessageSendService extends HiverBaseService<MessageSend, Long> {
    /**
     * 发送消息 带websock推送
     */
    MessageSend send(MessageSend messageSend);

    /**
     * 通过消息id删除
     */
    void deleteByMessageId(Long messageId);

    /**
     * 多条件分页获取
     */
    Page<MessageSend> findByCondition(MessageSend messageSend, Pageable pageable);

    /**
     * 批量更新消息状态
     */
    void updateStatusByUserId(Long userId, Integer status);

    /**
     * 通过userId删除
     */
    void deleteByUserId(Long userId);

    /**
     * 获得填充变量后的消息
     */
    Message getTemplateMessage(Long messageId, Map<String, String> params);

    /**
     * 发送模版消息
     *
     * @param userIds   发送用户
     * @param messageId 消息ID
     * @param params    消息模版变量参数
     */
    void sendTemplateMessage(List<Long> userIds, Long messageId, Map<String, String> params);

    /**
     * 发送模版消息
     *
     * @param userId    发送给单个用户
     * @param messageId 消息ID
     * @param params    消息模版变量参数
     */
    void sendTemplateMessage(Long userId, Long messageId, Map<String, String> params);
}
