/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.system.serviceimpl;

import jakarta.transaction.Transactional;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import plus.hiver.common.base.HiverBaseServiceImpl;
import plus.hiver.module.system.dao.DictDao;
import plus.hiver.module.system.entity.Dict;
import plus.hiver.module.system.service.DictService;

import java.util.List;

/**
 * 字典接口实现
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Slf4j
@Service
@Transactional
public class DictServiceImpl extends HiverBaseServiceImpl<Dict, Long, DictDao> implements DictService {
    public DictServiceImpl(DictDao dao) {
        super(dao);
    }

    @Override
    public List<Dict> findAllOrderBySortOrder() {
        return dao.findAllOrderBySortOrder();
    }

    @Override
    public Dict findByType(String type) {
        return dao.findByType(type);
    }

    @Override
    public List<Dict> findByTitleOrTypeLike(String key) {
        return dao.findByTitleOrTypeLike(key);
    }
}
