/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.system.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * OSS配置
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Data
public class OssSetting implements Serializable {
    @Schema(description = "服务商")
    private String serviceName;

    @Schema(description = "ak")
    private String accessKey;

    @Schema(description = "sk")
    private String secretKey;

    @Schema(description = "endpoint域名")
    private String endpoint;

    @Schema(description = "bucket空间")
    private String bucket;

    @Schema(description = "http")
    private String http;

    @Schema(description = "zone存储区域")
    private Integer zone;

    @Schema(description = "bucket存储区域")
    private String bucketRegion;

    @Schema(description = "本地存储路径")
    private String filePath;

    @Schema(description = "是否改变secrectKey")
    private Boolean changed;
}
