/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.system.controller;

import cn.hutool.core.util.StrUtil;
import com.google.gson.Gson;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.redis.RedisTemplateHelper;
import plus.hiver.common.utils.IpInfoUtil;
import plus.hiver.common.utils.PageUtil;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.utils.SecurityUtil;
import plus.hiver.common.vo.OnlineUserVo;
import plus.hiver.common.vo.PageVo;

@RestController
@Tag(name="\u5728\u7ebf\u7528\u6237\u7ba1\u7406\u63a7\u5236\u5668")
@PermissionTag(permission="onlineUser:*")
@RequestMapping(value={"/hiver/onlineUser"})
@Transactional
public class OnlineUserController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OnlineUserController.class);
    @Resource
    private SecurityUtil securityUtil;
    @Resource
    private RedisTemplateHelper redisTemplateHelper;

    @GetMapping(value={"/getAllByPage"})
    @Operation(summary="\u5206\u9875\u83b7\u53d6\u5168\u90e8")
    public Result<Page<OnlineUserVo>> getAllByPage(@RequestParam(required=false) String object, PageVo pageVo) {
        Boolean bl = this.securityUtil.getCurrUser().hasRole("ROLE_ADMIN");
        ArrayList<OnlineUserVo> arrayList = new ArrayList<OnlineUserVo>();
        object = StrUtil.isNotBlank((CharSequence)object) ? "ONLINE_USER:*" + (String)object + "*" : "ONLINE_USER:*";
        Set set = this.redisTemplateHelper.scan((String)object);
        for (String string : set) {
            String string2 = this.redisTemplateHelper.get(string);
            if (StrUtil.isBlank((CharSequence)string2)) continue;
            OnlineUserVo onlineUserVo = (OnlineUserVo)new Gson().fromJson(string2, OnlineUserVo.class);
            onlineUserVo.setIpInfo(IpInfoUtil.getIpCity((String)onlineUserVo.getIp()));
            if (!bl.booleanValue()) {
                onlineUserVo.setAccessToken("");
            }
            arrayList.add(onlineUserVo);
        }
        PageImpl pageImpl = new PageImpl(PageUtil.listToPage((PageVo)pageVo, arrayList), PageUtil.initPage((PageVo)pageVo), (long)set.size());
        return new ResultUtil().setData((Object)pageImpl);
    }

    @PostMapping(value={"/logout"})
    @Operation(summary="\u6279\u91cf\u5f3a\u5236\u4e0b\u7ebf")
    public Result logout(@RequestBody List<OnlineUserVo> list) {
        for (OnlineUserVo onlineUserVo : list) {
            if (StrUtil.isBlank((CharSequence)onlineUserVo.getUsername()) || StrUtil.isBlank((CharSequence)onlineUserVo.getAccessToken())) {
                return ResultUtil.error((String)"\u7f3a\u5c11\u5fc5\u8981\u5b57\u6bb5");
            }
            this.redisTemplateHelper.delete("username::" + onlineUserVo.getUsername());
            if (onlineUserVo.getIsJWT().booleanValue()) {
                this.redisTemplateHelper.delete("ONLINE_USER:" + onlineUserVo.getUsername());
                continue;
            }
            this.redisTemplateHelper.delete("HIVER_TOKEN_PRE:" + onlineUserVo.getAccessToken());
            this.redisTemplateHelper.delete("HIVER_USER_TOKEN:" + onlineUserVo.getUsername());
            this.redisTemplateHelper.delete("ONLINE_USER:" + onlineUserVo.getUsername() + ":" + onlineUserVo.getAccessToken());
        }
        return ResultUtil.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @Generated
    public OnlineUserController(SecurityUtil securityUtil, RedisTemplateHelper redisTemplateHelper) {
        this.securityUtil = securityUtil;
        this.redisTemplateHelper = redisTemplateHelper;
    }
}

