/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.system.dao;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import plus.hiver.common.base.HiverBaseDao;
import plus.hiver.module.system.entity.MessageSend;

/**
 * 消息发送数据处理层
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Repository
public interface MessageSendDao extends HiverBaseDao<MessageSend, Long> {
    /**
     * 通过消息id删除
     */
    @Modifying
    @Query("delete from MessageSend m where m.messageId = ?1")
    void deleteByMessageId(Long messageId);

    /**
     * 批量更新消息状态
     */
    @Modifying
    @Query("update MessageSend m set m.status=?2 where m.userId=?1")
    void updateStatusByUserId(Long userId, Integer status);

    /**
     * 通过userId删除
     */
    @Modifying
    @Query("delete from MessageSend m where m.userId = ?1 and m.status=?2")
    void deleteByUserId(Long userId, Integer status);
}
