/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.system.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 短信配置
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Data
@Accessors(chain = true)
public class SmsSetting implements Serializable {
    @Schema(description = "服务商")
    private String serviceName;

    @Schema(description = "ak")
    private String accessKey;

    @Schema(description = "sk")
    private String secretKey;

    @Schema(description = "appId")
    private String appId;

    @Schema(description = "签名")
    private String signName;

    @Schema(description = "使用场景模版类型")
    private String type;

    @Schema(description = "模版code")
    private String templateCode;

    @Schema(description = "是否改变secrectKey")
    private Boolean changed;
}
