/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.system.service;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import plus.hiver.common.base.HiverBaseService;
import plus.hiver.common.vo.SearchVo;
import plus.hiver.module.system.entity.Message;

import java.util.List;

/**
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface MessageService extends HiverBaseService<Message, Long> {
    /**
     * 多条件分页获取
     */
    Page<Message> findByCondition(Message message, SearchVo searchVo, Pageable pageable);

    /**
     * 通过创建发送标识获取
     */
    List<Message> findByCreateSend(Boolean createSend);
}
