/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.system.utils;

import cn.hutool.core.bean.BeanUtil;
import plus.hiver.common.entity.Permission;
import plus.hiver.module.system.vo.MenuVo;

/**
 * Vo工具类
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public class VoUtil {
    /**
     * Permission转MenuVo
     *
     * @param p 权限信息
     * @return
     */
    public static MenuVo permissionToMenuVo(Permission p) {
        MenuVo menuVo = new MenuVo();
        BeanUtil.copyProperties(p, menuVo);
        return menuVo;
    }
}
