/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.system.controller;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.constant.MessageConstant;
import plus.hiver.common.constant.SettingConstant;
import plus.hiver.common.redis.RedisTemplateHelper;
import plus.hiver.common.service.UserService;
import plus.hiver.common.sms.SmsUtil;
import plus.hiver.common.utils.CreateVerifyCode;
import plus.hiver.common.utils.IpInfoUtil;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.utils.StringUtil;

@RestController
@Tag(name="\u9a8c\u8bc1\u7801\u63a5\u53e3")
@PermissionTag(permission="common:captcha:*")
@RequestMapping(value={"/hiver/common/captcha"})
public class CaptchaController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CaptchaController.class);
    @Resource
    private RedisTemplateHelper redisTemplateHelper;
    @Resource
    private UserService userService;
    @Resource
    private IpInfoUtil ipInfoUtil;
    @Resource
    private SmsUtil smsUtil;

    @GetMapping(value={"/init"})
    @Operation(summary="\u521d\u59cb\u5316\u9a8c\u8bc1\u7801")
    public Result initCaptcha(@Parameter(name="\u4ec5\u751f\u6210\u6570\u5b57") @RequestParam(required=false, defaultValue="false") Boolean bl, @Parameter(name="\u9a8c\u8bc1\u7801\u957f\u5ea6") @RequestParam(required=false, defaultValue="4") Integer n) {
        String string = IdUtil.simpleUUID();
        String string2 = bl != false ? StringUtil.randomDigit((int)n) : StringUtil.randomStr((int)n);
        this.redisTemplateHelper.set(string, string2, 2L, TimeUnit.MINUTES);
        return ResultUtil.data((Object)string);
    }

    @GetMapping(value={"/draw/{captchaId}"})
    @Operation(summary="\u6839\u636e\u9a8c\u8bc1\u7801ID\u83b7\u53d6\u56fe\u7247")
    public void drawCaptcha(@PathVariable(value="captchaId") String string, HttpServletResponse httpServletResponse) throws IOException {
        String string2 = this.redisTemplateHelper.get(string);
        CreateVerifyCode createVerifyCode = new CreateVerifyCode(116, 36, 4, 10, string2);
        httpServletResponse.setContentType("image/png");
        createVerifyCode.write((OutputStream)httpServletResponse.getOutputStream());
    }

    @GetMapping(value={"/sendRegistSms/{mobile}"})
    @Operation(summary="\u53d1\u9001\u6ce8\u518c\u77ed\u4fe1\u9a8c\u8bc1\u7801")
    public Result sendRegistSmsCode(@PathVariable String string, HttpServletRequest httpServletRequest) {
        return this.sendSms(string, MessageConstant.SMS_RANGE_UNREG, SettingConstant.SMS_TYPE.SMS_COMMON.name(), httpServletRequest);
    }

    @GetMapping(value={"/sendLoginSms/{mobile}"})
    @Operation(summary="\u53d1\u9001\u767b\u5f55\u77ed\u4fe1\u9a8c\u8bc1\u7801")
    public Result sendLoginSmsCode(@PathVariable String string, HttpServletRequest httpServletRequest) {
        return this.sendSms(string, MessageConstant.SMS_RANGE_REG, SettingConstant.SMS_TYPE.SMS_COMMON.name(), httpServletRequest);
    }

    @GetMapping(value={"/sendResetSms/{mobile}"})
    @Operation(summary="\u53d1\u9001\u91cd\u7f6e\u5bc6\u7801\u77ed\u4fe1\u9a8c\u8bc1\u7801")
    public Result sendResetSmsCode(@PathVariable String string, HttpServletRequest httpServletRequest) {
        return this.sendSms(string, MessageConstant.SMS_RANGE_REG, SettingConstant.SMS_TYPE.SMS_RESET_PASS.name(), httpServletRequest);
    }

    @GetMapping(value={"/sendEditMobileSms/{mobile}"})
    @Operation(summary="\u53d1\u9001\u4fee\u6539\u624b\u673a\u77ed\u4fe1\u9a8c\u8bc1\u7801")
    public Result sendEditMobileSmsCode(@PathVariable String string, HttpServletRequest httpServletRequest) {
        if (this.userService.findByMobile(string) != null) {
            return ResultUtil.error((String)"\u8be5\u624b\u673a\u53f7\u5df2\u7ed1\u5b9a\u8d26\u6237");
        }
        return this.sendSms(string, MessageConstant.SMS_RANGE_ALL, SettingConstant.SMS_TYPE.SMS_COMMON.name(), httpServletRequest);
    }

    public Result sendSms(String string, Integer n, String string2, HttpServletRequest httpServletRequest) {
        if (MessageConstant.SMS_RANGE_REG.equals(n) && this.userService.findByMobile(string) == null) {
            return ResultUtil.error((String)"\u624b\u673a\u53f7\u672a\u6ce8\u518c");
        }
        if (MessageConstant.SMS_RANGE_UNREG.equals(n) && this.userService.findByMobile(string) != null) {
            return ResultUtil.error((String)"\u624b\u673a\u53f7\u5df2\u6ce8\u518c");
        }
        String string3 = "sendSms:" + IpInfoUtil.getIpAddr((HttpServletRequest)httpServletRequest);
        String string4 = this.redisTemplateHelper.get(string3);
        if (StrUtil.isNotBlank((CharSequence)string4)) {
            return ResultUtil.error((String)"\u60a8\u53d1\u9001\u7684\u592a\u9891\u7e41\u5566\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        String string5 = StringUtil.randomDigit((int)6);
        this.redisTemplateHelper.set("HIVER_PRE_SMS:" + string, string5, 5L, TimeUnit.MINUTES);
        this.smsUtil.sendCode(string, string5, string2);
        this.redisTemplateHelper.set(string3, "sended", 1L, TimeUnit.MINUTES);
        return ResultUtil.success((String)"\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801\u6210\u529f");
    }

    @Generated
    public CaptchaController(RedisTemplateHelper redisTemplateHelper, UserService userService, IpInfoUtil ipInfoUtil, SmsUtil smsUtil) {
        this.redisTemplateHelper = redisTemplateHelper;
        this.userService = userService;
        this.ipInfoUtil = ipInfoUtil;
        this.smsUtil = smsUtil;
    }
}

