/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.system.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.base.HiverBaseEntity;
import plus.hiver.common.entity.StopWord;
import plus.hiver.common.service.StopWordService;
import plus.hiver.common.utils.PageUtil;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.utils.StopWordsUtil;
import plus.hiver.common.vo.PageVo;
import plus.hiver.common.vo.SearchVo;

@RestController
@Tag(name="\u7981\u7528\u8bcd\u7ba1\u7406\u7ba1\u7406\u63a5\u53e3")
@PermissionTag(permission="stopWord:*")
@RequestMapping(value={"/hiver/stopWord"})
@Transactional
public class StopWordController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StopWordController.class);
    @Resource
    private StopWordService stopWordService;

    @GetMapping(value={"/getByCondition"})
    @Operation(summary="\u591a\u6761\u4ef6\u5206\u9875\u83b7\u53d6")
    public Result<Page<StopWord>> getByCondition(StopWord stopWord, SearchVo searchVo, PageVo pageVo) {
        Page page = this.stopWordService.findByCondition(stopWord, searchVo, PageUtil.initPage((PageVo)pageVo));
        return new ResultUtil().setData((Object)page);
    }

    @PostMapping(value={"/save"})
    @Operation(summary="\u4fdd\u5b58\u6570\u636e")
    public Result<StopWord> save(@RequestBody StopWord stopWord) {
        StopWord stopWord2 = (StopWord)this.stopWordService.save((HiverBaseEntity)stopWord);
        StopWordsUtil.addWord((String)stopWord.getTitle());
        return new ResultUtil().setData((Object)stopWord2);
    }

    @PostMapping(value={"/edit"})
    @Operation(summary="\u66f4\u65b0\u6570\u636e")
    public Result<StopWord> update(@RequestBody StopWord stopWord) {
        StopWord stopWord2 = (StopWord)this.stopWordService.get(stopWord.getId());
        StopWord stopWord3 = (StopWord)this.stopWordService.update((HiverBaseEntity)stopWord);
        StopWordsUtil.removeWord((String)stopWord2.getTitle());
        StopWordsUtil.addWord((String)stopWord.getTitle());
        return new ResultUtil().setData((Object)stopWord3);
    }

    @PostMapping(value={"/delByIds"})
    @Operation(summary="\u6279\u91cf\u901a\u8fc7id\u5220\u9664")
    public Result delByIds(@RequestParam Long[] longArray) {
        for (Long l : longArray) {
            StopWord stopWord = (StopWord)this.stopWordService.get(l);
            this.stopWordService.delete(l);
            StopWordsUtil.removeWord((String)stopWord.getTitle());
        }
        return ResultUtil.success((String)"\u6279\u91cf\u901a\u8fc7id\u5220\u9664\u6570\u636e\u6210\u529f");
    }

    @Generated
    public StopWordController(StopWordService stopWordService) {
        this.stopWordService = stopWordService;
    }
}

