/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.system.controller;

import cn.hutool.core.util.StrUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.validation.Valid;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.data.domain.Page;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.base.HiverBaseEntity;
import plus.hiver.common.constant.HiverConstant;
import plus.hiver.common.constant.UserConstant;
import plus.hiver.common.dto.RoleDTO;
import plus.hiver.common.entity.Department;
import plus.hiver.common.entity.Role;
import plus.hiver.common.entity.User;
import plus.hiver.common.entity.UserRole;
import plus.hiver.common.redis.RedisTemplateHelper;
import plus.hiver.common.service.DepartmentHeaderService;
import plus.hiver.common.service.DepartmentService;
import plus.hiver.common.service.RoleService;
import plus.hiver.common.service.UserRoleService;
import plus.hiver.common.service.UserService;
import plus.hiver.common.service.mybatis.IUserRoleService;
import plus.hiver.common.utils.NameUtil;
import plus.hiver.common.utils.PageUtil;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.utils.SecurityUtil;
import plus.hiver.common.utils.StringUtil;
import plus.hiver.common.vo.PageVo;
import plus.hiver.common.vo.SearchVo;
import plus.hiver.module.system.async.AddMessage;

@RestController
@Controller
@Tag(name="\u7528\u6237\u63a5\u53e3")
@PermissionTag(permission="user:*")
@RequestMapping(value={"/hiver/user"})
@CacheConfig(cacheNames={"user"})
@Transactional
public class UserController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserController.class);
    public static final String USER = "username::";
    @Resource
    private UserService userService;
    @Resource
    private RoleService roleService;
    @Resource
    private DepartmentService departmentService;
    @Resource
    private DepartmentHeaderService departmentHeaderService;
    @Resource
    private IUserRoleService iUserRoleService;
    @Resource
    private UserRoleService userRoleService;
    @Resource
    private AddMessage addMessage;
    @Resource
    private SecurityUtil securityUtil;
    @PersistenceContext
    private EntityManager entityManager;
    @Resource
    private RedisTemplateHelper redisTemplateHelper;

    @GetMapping(value={"/info"})
    @Operation(summary="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u63a5\u53e3")
    public Result<User> getUserInfo() {
        User user = this.securityUtil.getCurrUser();
        this.entityManager.detach((Object)user);
        user.setPassword(null);
        return new ResultUtil().setData((Object)user);
    }

    @PostMapping(value={"/unlock"})
    @Operation(summary="\u89e3\u9501\u9a8c\u8bc1\u5bc6\u7801")
    public Result unLock(@RequestParam String string) {
        User user = this.securityUtil.getCurrUser();
        if (!new BCryptPasswordEncoder().matches((CharSequence)(string + user.getSalt()), user.getPassword())) {
            return ResultUtil.error((String)"\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        return ResultUtil.data(null);
    }

    @PostMapping(value={"/edit"})
    @Operation(summary="\u4fee\u6539\u7528\u6237\u81ea\u5df1\u8d44\u6599", description="\u7528\u6237\u540d\u5bc6\u7801\u7b49\u4e0d\u4f1a\u4fee\u6539 \u9700\u8981username\u66f4\u65b0\u7f13\u5b58")
    @CacheEvict(key="#u.username")
    public Result editOwn(@RequestBody User user) {
        User user2 = this.securityUtil.getCurrUser();
        user.setUsername(user2.getUsername()).setPassword(user2.getPassword()).setType(user2.getType()).setStatus(user2.getStatus());
        if (user.getDepartmentId() == 0L) {
            user.setDepartmentId(null);
        }
        this.userService.update((HiverBaseEntity)user);
        return ResultUtil.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @PostMapping(value={"/modifyPass"})
    @Operation(summary="\u4fee\u6539\u5bc6\u7801")
    public Result modifyPass(@Parameter(name="\u65e7\u5bc6\u7801") @RequestParam String string, @Parameter(name="\u65b0\u5bc6\u7801") @RequestParam String string2, @Parameter(name="\u5bc6\u7801\u5f3a\u5ea6") @RequestParam String string3) {
        User user = this.securityUtil.getCurrUser();
        if (!new BCryptPasswordEncoder().matches((CharSequence)(string + user.getSalt()), user.getPassword())) {
            return ResultUtil.error((String)"\u65e7\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        String string4 = StringUtil.randomStr((int)8);
        String string5 = new BCryptPasswordEncoder().encode((CharSequence)(string2 + string4));
        user.setPassword(string5);
        user.setPassStrength(string3);
        user.setSalt(string4);
        this.userService.update((HiverBaseEntity)user);
        this.redisTemplateHelper.delete(USER + user.getUsername());
        return ResultUtil.success((String)"\u4fee\u6539\u5bc6\u7801\u6210\u529f");
    }

    @PostMapping(value={"/changeMobile"})
    @Operation(summary="\u4fee\u6539\u7ed1\u5b9a\u624b\u673a")
    public Result changeMobile(@RequestParam String string) {
        User user = this.securityUtil.getCurrUser();
        user.setMobile(string);
        this.userService.update((HiverBaseEntity)user);
        this.redisTemplateHelper.delete(USER + user.getUsername());
        return ResultUtil.success((String)"\u4fee\u6539\u624b\u673a\u53f7\u6210\u529f");
    }

    @PostMapping(value={"/resetPass"})
    @Operation(summary="\u91cd\u7f6e\u5bc6\u7801")
    public Result resetPass(@RequestParam Long[] longArray) {
        for (Long l : longArray) {
            User user = (User)this.userService.get(l);
            user.setPassword(new BCryptPasswordEncoder().encode((CharSequence)"123456"));
            this.userService.update((HiverBaseEntity)user);
            this.redisTemplateHelper.delete(USER + user.getUsername());
        }
        return ResultUtil.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @GetMapping(value={"/getByCondition"})
    @Operation(summary="\u591a\u6761\u4ef6\u5206\u9875\u83b7\u53d6\u7528\u6237\u5217\u8868")
    public Result<Page<User>> getByCondition(User user, SearchVo searchVo, PageVo pageVo) {
        Page page = this.userService.findByCondition(user, searchVo, PageUtil.initPage((PageVo)pageVo));
        for (User user2 : page.getContent()) {
            List list = this.iUserRoleService.findByUserId(user2.getId());
            List list2 = list.stream().map(role -> new RoleDTO().setId(role.getId()).setName(role.getName()).setDescription(role.getDescription())).collect(Collectors.toList());
            user2.setRoles(list2);
            this.entityManager.detach((Object)user2);
            user2.setPassword(null);
        }
        return new ResultUtil().setData((Object)page);
    }

    @GetMapping(value={"/getByDepartmentId/{departmentId}"})
    @Operation(summary="\u591a\u6761\u4ef6\u5206\u9875\u83b7\u53d6\u7528\u6237\u5217\u8868")
    public Result<List<User>> getByCondition(@PathVariable Long l) {
        List list = this.userService.findByDepartmentId(l);
        list.forEach(user -> {
            this.entityManager.detach(user);
            user.setPassword(null);
        });
        return new ResultUtil().setData((Object)list);
    }

    @GetMapping(value={"/searchByName/{username}"})
    @Operation(summary="\u901a\u8fc7\u7528\u6237\u540d\u641c\u7d22\u7528\u6237")
    public Result<List<User>> searchByName(@PathVariable String string) throws UnsupportedEncodingException {
        List list = this.userService.findByUsernameLikeAndStatus(URLDecoder.decode(string, "utf-8"), HiverConstant.STATUS_NORMAL);
        list.forEach(user -> {
            this.entityManager.detach(user);
            user.setPassword(null);
        });
        return new ResultUtil().setData((Object)list);
    }

    @GetMapping(value={"/getAll"})
    @Operation(summary="\u83b7\u53d6\u5168\u90e8\u7528\u6237\u6570\u636e")
    public Result<List<User>> getAll() {
        List list = this.userService.getAll();
        list.forEach(user -> {
            this.entityManager.detach(user);
            user.setPassword(null);
        });
        return new ResultUtil().setData((Object)list);
    }

    @PostMapping(value={"/admin/add"})
    @Operation(summary="\u6dfb\u52a0\u7528\u6237")
    public Result add(@Valid @RequestBody User user) {
        Department department;
        NameUtil.checkUserInfo((User)user);
        if (StrUtil.isBlank((CharSequence)user.getNickname())) {
            return ResultUtil.error((String)"nickname\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String string = StringUtil.randomStr((int)8);
        String string2 = new BCryptPasswordEncoder().encode((CharSequence)(user.getPassword() + string));
        user.setPassword(string2);
        user.setSalt(string);
        if (user.getDepartmentId() > 0L) {
            department = (Department)this.departmentService.get(user.getDepartmentId());
            if (department != null) {
                user.setDepartmentTitle(department.getTitle());
            }
        } else {
            user.setDepartmentId(null);
            user.setDepartmentTitle("");
        }
        department = (User)this.userService.save((HiverBaseEntity)user);
        if (user.getRoleIds() != null) {
            List list = Arrays.asList(user.getRoleIds()).stream().map(l -> new UserRole().setUserId(user.getId()).setRoleId(l)).collect(Collectors.toList());
            this.userRoleService.saveOrUpdateAll(list);
        }
        this.addMessage.addSendMessage(department.getId());
        return ResultUtil.success((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @PostMapping(value={"/admin/edit"})
    @Operation(summary="\u7ba1\u7406\u5458\u4fee\u6539\u8d44\u6599", description="\u9700\u8981\u901a\u8fc7id\u83b7\u53d6\u539f\u7528\u6237\u4fe1\u606f \u9700\u8981username\u66f4\u65b0\u7f13\u5b58")
    @CacheEvict(key="#u.username")
    public Result edit(@RequestBody User user) {
        Object object;
        User user2 = (User)this.userService.get(user.getId());
        user.setUsername(user2.getUsername());
        if (!user2.getMobile().equals(user.getMobile()) && this.userService.findByMobile(user.getMobile()) != null) {
            return ResultUtil.error((String)"\u8be5\u624b\u673a\u53f7\u5df2\u7ed1\u5b9a\u5176\u4ed6\u8d26\u6237");
        }
        if (!user2.getEmail().equals(user.getEmail()) && this.userService.findByEmail(user.getEmail()) != null) {
            return ResultUtil.error((String)"\u8be5\u90ae\u7bb1\u5df2\u7ed1\u5b9a\u5176\u4ed6\u8d26\u6237");
        }
        if (user.getDepartmentId() > 0L) {
            object = (Department)this.departmentService.get(user.getDepartmentId());
            if (object != null) {
                user.setDepartmentTitle(object.getTitle());
            }
        } else {
            user.setDepartmentId(null);
            user.setDepartmentTitle("");
        }
        user.setPassword(user2.getPassword());
        this.userService.update((HiverBaseEntity)user);
        this.userRoleService.deleteByUserId(user.getId());
        if (user.getRoleIds() != null) {
            object = Arrays.asList(user.getRoleIds()).stream().map(l -> new UserRole().setRoleId(l).setUserId(user.getId())).collect(Collectors.toList());
            this.userRoleService.saveOrUpdateAll((List)object);
        }
        this.redisTemplateHelper.delete("userRole::" + user.getId());
        this.redisTemplateHelper.delete("userRole::depIds:" + user.getId());
        this.redisTemplateHelper.delete("permission::userMenuList:" + user.getId());
        return ResultUtil.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @PostMapping(value={"/admin/disable/{userId}"})
    @Operation(summary="\u540e\u53f0\u7981\u7528\u7528\u6237")
    public Result disable(@Parameter(name="\u7528\u6237\u552f\u4e00id\u6807\u8bc6") @PathVariable Long l) {
        User user = (User)this.userService.get(l);
        user.setStatus(UserConstant.USER_STATUS_LOCK);
        this.userService.update((HiverBaseEntity)user);
        this.redisTemplateHelper.delete(USER + user.getUsername());
        return ResultUtil.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/admin/enable/{userId}"})
    @Operation(summary="\u540e\u53f0\u542f\u7528\u7528\u6237")
    public Result enable(@Parameter(name="\u7528\u6237\u552f\u4e00id\u6807\u8bc6") @PathVariable Long l) {
        User user = (User)this.userService.get(l);
        user.setStatus(UserConstant.USER_STATUS_NORMAL);
        this.userService.update((HiverBaseEntity)user);
        this.redisTemplateHelper.delete(USER + user.getUsername());
        return ResultUtil.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/delByIds"})
    @Operation(summary="\u6279\u91cf\u901a\u8fc7ids\u5220\u9664")
    public Result delAllByIds(@RequestParam Long[] longArray) {
        for (Long l : longArray) {
            User user = (User)this.userService.get(l);
            this.redisTemplateHelper.delete(USER + user.getUsername());
            this.redisTemplateHelper.delete("userRole::" + user.getId());
            this.redisTemplateHelper.delete("userRole::depIds:" + user.getId());
            this.redisTemplateHelper.delete("permission::userMenuList:" + user.getId());
            this.redisTemplateHelper.deleteByPattern("department::*");
            this.userService.delete(l);
            this.userRoleService.deleteByUserId(l);
            this.departmentHeaderService.deleteByUserId(l);
        }
        return ResultUtil.success((String)"\u6279\u91cf\u901a\u8fc7id\u5220\u9664\u6570\u636e\u6210\u529f");
    }

    @PostMapping(value={"/importData"})
    @Operation(summary="\u5bfc\u5165\u7528\u6237\u6570\u636e")
    public Result importData(@RequestBody List<User> list) {
        Object object;
        Object object2;
        Object object32;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = 0;
        for (Object object32 : list) {
            ++n;
            if (StrUtil.isBlank((CharSequence)object32.getUsername()) || StrUtil.isBlank((CharSequence)object32.getPassword()) || StrUtil.isBlank((CharSequence)object32.getMobile()) || StrUtil.isBlank((CharSequence)object32.getEmail())) {
                arrayList.add(n);
                arrayList2.add("\u7528\u6237\u540d\u3001\u5bc6\u7801\u3001\u624b\u673a\u3001\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (this.userService.findByUsername(object32.getUsername()) != null || this.userService.findByMobile(object32.getMobile()) != null || this.userService.findByEmail(object32.getEmail()) != null) {
                arrayList.add(n);
                arrayList2.add("\u7528\u6237\u540d\u3001\u624b\u673a\u3001\u90ae\u7bb1\u5df2\u5b58\u5728");
                continue;
            }
            object32.setPassword(new BCryptPasswordEncoder().encode((CharSequence)object32.getPassword()));
            if (object32.getDepartmentId() > 0L) {
                object2 = (Department)this.departmentService.findById(object32.getDepartmentId());
                if (object2 == null) {
                    arrayList.add(n);
                    arrayList2.add("\u90e8\u95e8id\u4e0d\u5b58\u5728");
                    continue;
                }
                object32.setDepartmentTitle(object2.getTitle());
            }
            if (object32.getStatus() == null) {
                object32.setStatus(UserConstant.USER_STATUS_NORMAL);
            }
            this.userService.save((HiverBaseEntity)object32);
            if (object32.getDefaultRole() == null || object32.getDefaultRole() != 1 || (object2 = this.roleService.findByDefaultRole(Boolean.valueOf(true))) == null || object2.size() <= 0) continue;
            object = object2.iterator();
            while (object.hasNext()) {
                Role role = (Role)object.next();
                UserRole userRole = new UserRole().setUserId(object32.getId()).setRoleId(role.getId());
                this.userRoleService.save((HiverBaseEntity)userRole);
            }
        }
        int n2 = list.size() - arrayList.size();
        object32 = "\u5168\u90e8\u5bfc\u5165\u6210\u529f\uff0c\u5171\u8ba1 " + n2 + " \u6761\u6570\u636e";
        object2 = "\u5bfc\u5165\u6210\u529f " + n2 + " \u6761\uff0c\u5931\u8d25 " + arrayList.size() + " \u6761\u6570\u636e\u3002<br>\u7b2c " + arrayList + " \u884c\u6570\u636e\u5bfc\u5165\u51fa\u9519\uff0c\u9519\u8bef\u539f\u56e0\u5206\u522b\u4e3a\uff1a<br>" + arrayList2;
        object = arrayList.isEmpty() ? object32 : object2;
        return ResultUtil.success((String)object);
    }

    @Generated
    public UserController(UserService userService, RoleService roleService, DepartmentService departmentService, DepartmentHeaderService departmentHeaderService, IUserRoleService iUserRoleService, UserRoleService userRoleService, AddMessage addMessage, SecurityUtil securityUtil, EntityManager entityManager, RedisTemplateHelper redisTemplateHelper) {
        this.userService = userService;
        this.roleService = roleService;
        this.departmentService = departmentService;
        this.departmentHeaderService = departmentHeaderService;
        this.iUserRoleService = iUserRoleService;
        this.userRoleService = userRoleService;
        this.addMessage = addMessage;
        this.securityUtil = securityUtil;
        this.entityManager = entityManager;
        this.redisTemplateHelper = redisTemplateHelper;
    }
}

