/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.system.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import plus.hiver.common.base.HiverBaseEntity;
import plus.hiver.common.constant.HiverConstant;

import java.math.BigDecimal;

/**
 * 字段内容实体类
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Data
@Entity
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Table(name = "t_dict_data")
@TableName("t_dict_data")
@Tag(name = "字典数据")
public class DictData extends HiverBaseEntity {
    private static final long serialVersionUID = 1L;

    @Schema(description = "数据名称")
    private String title;

    @Schema(description = "数据值")
    private String value;

    @Schema(description = "排序值")
    @Column(precision = 10, scale = 2)
    private BigDecimal sortOrder;

    @Schema(description = "是否启用 0启用 -1禁用")
    private Integer status = HiverConstant.STATUS_NORMAL;

    @Schema(description = "备注")
    private String description;

    @Schema(description = "所属字典")
    private Long dictId;
}
