/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.system.service;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import plus.hiver.common.base.HiverBaseService;
import plus.hiver.module.system.entity.DictData;

import java.util.List;

/**
 * 字典数据接口
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
public interface DictDataService extends HiverBaseService<DictData, Long> {
    /**
     * 多条件获取
     *
     * @param dictData 条件
     * @param pageable 分页
     * @return 结果
     */
    Page<DictData> findByCondition(DictData dictData, Pageable pageable);

    /**
     * 通过dictId获取启用字典 已排序
     *
     * @param dictId 字典ID
     * @return 字典数据列表
     */
    List<DictData> findByDictId(Long dictId);

    /**
     * 通过dictId删除
     *
     * @param dictId 字典ID
     */
    void deleteByDictId(Long dictId);

    /**
     * 通过dictId和值获取
     *
     * @param dictId 字典ID
     * @param value  字典值
     * @return 字典数据
     */
    DictData findByDictIdAndValue(Long dictId, String value);
}
