/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.system.controller;

import cn.hutool.core.util.StrUtil;
import com.google.gson.Gson;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.thymeleaf.context.Context;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.base.HiverBaseEntity;
import plus.hiver.common.entity.Setting;
import plus.hiver.common.entity.User;
import plus.hiver.common.exception.HiverException;
import plus.hiver.common.redis.RedisTemplateHelper;
import plus.hiver.common.service.SettingService;
import plus.hiver.common.service.UserService;
import plus.hiver.common.utils.EmailUtil;
import plus.hiver.common.utils.IpInfoUtil;
import plus.hiver.common.utils.ObjectUtil;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.utils.SecurityUtil;
import plus.hiver.common.utils.StringUtil;
import plus.hiver.common.vo.EmailValidate;
import plus.hiver.common.vo.OtherSetting;

@RestController
@Tag(name="\u90ae\u7bb1\u9a8c\u8bc1\u63a5\u53e3")
@PermissionTag(permission="email:*")
@RequestMapping(value={"/hiver/email"})
@Transactional
public class EmailValidateController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmailValidateController.class);
    @Resource
    private EmailUtil emailUtil;
    @Resource
    private RedisTemplateHelper redisTemplateHelper;
    @Resource
    private UserService userService;
    @Resource
    private IpInfoUtil ipInfoUtil;
    @Resource
    private SettingService settingService;
    @Resource
    private SecurityUtil securityUtil;

    public OtherSetting getOtherSetting() {
        Setting setting = this.settingService.findByKey("OTHER_SETTING");
        if (StrUtil.isBlank((CharSequence)setting.getValue())) {
            throw new HiverException("\u7cfb\u7edf\u672a\u914d\u7f6e\u8bbf\u95ee\u57df\u540d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return (OtherSetting)new Gson().fromJson(setting.getValue(), OtherSetting.class);
    }

    @GetMapping(value={"/sendEditCode/{email}"})
    @Operation(summary="\u53d1\u9001\u4fee\u6539\u90ae\u7bb1\u9a8c\u8bc1\u7801")
    public Result sendEditCode(@PathVariable String string, HttpServletRequest httpServletRequest) {
        return this.sendEmailCode(string, "\u4fee\u6539\u90ae\u7bb1", "\u3010\u6d77\u6587\u79d1\u6280\u3011\u4fee\u6539\u90ae\u7bb1\u9a8c\u8bc1", "code-email", httpServletRequest);
    }

    @GetMapping(value={"/sendResetCode/{email}"})
    @Operation(summary="\u53d1\u9001\u91cd\u7f6e\u5bc6\u7801\u90ae\u7bb1\u9a8c\u8bc1\u7801")
    public Result sendResetCode(@PathVariable String string, HttpServletRequest httpServletRequest) {
        return this.sendEmailCode(string, "\u91cd\u7f6e\u5bc6\u7801", "\u3010\u6d77\u6587\u79d1\u6280\u3011\u91cd\u7f6e\u5bc6\u7801\u90ae\u7bb1\u9a8c\u8bc1", "code-email", httpServletRequest);
    }

    public Result sendEmailCode(String string, String string2, String string3, String string4, HttpServletRequest httpServletRequest) {
        Object object;
        EmailValidate emailValidate = new EmailValidate();
        emailValidate.setOperation(string2);
        User user = this.userService.findByEmail(string);
        if ("\u4fee\u6539\u90ae\u7bb1".equals(string2)) {
            if (user != null) {
                return ResultUtil.error((String)"\u8be5\u90ae\u7bb1\u5df2\u7ed1\u5b9a\u8d26\u53f7");
            }
            object = this.securityUtil.getCurrUserSimple();
            emailValidate.setUsername(object.getUsername());
        } else if ("\u91cd\u7f6e\u5bc6\u7801".equals(string2)) {
            if (user == null) {
                return ResultUtil.error((String)"\u8be5\u90ae\u7bb1\u672a\u6ce8\u518c");
            }
            emailValidate.setUsername(user.getUsername());
        }
        object = "sendEmailCode:" + IpInfoUtil.getIpAddr((HttpServletRequest)httpServletRequest);
        String string5 = this.redisTemplateHelper.get((String)object);
        if (StrUtil.isNotBlank((CharSequence)string5)) {
            return ResultUtil.error((String)"\u60a8\u53d1\u9001\u7684\u592a\u9891\u7e41\u5566\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        String string6 = StringUtil.randomStr((int)6);
        emailValidate.setCode(string6);
        emailValidate.setEmail(string);
        emailValidate.setFullUrl(this.getOtherSetting().getDomain());
        Context context = new Context();
        context.setVariables(ObjectUtil.beanToMap((Object)emailValidate));
        this.redisTemplateHelper.set("HIVER_PRE_EMAIL:" + string, new Gson().toJson((Object)emailValidate, EmailValidate.class), 10L, TimeUnit.MINUTES);
        this.emailUtil.sendTemplateMail(string, string3, string4, context, new String[0]);
        this.redisTemplateHelper.set((String)object, "sended", 1L, TimeUnit.MINUTES);
        return ResultUtil.success((String)"\u53d1\u9001\u6210\u529f");
    }

    @PostMapping(value={"/editEmail"})
    @Operation(summary="\u4fee\u6539\u90ae\u7bb1\u6216\u91cd\u7f6e\u5bc6\u7801")
    public Result editEmail(@RequestParam String string) {
        User user = this.securityUtil.getCurrUser();
        user.setEmail(string);
        this.userService.update((HiverBaseEntity)user);
        this.redisTemplateHelper.delete("user::" + user.getUsername());
        return ResultUtil.success((String)"\u4fee\u6539\u90ae\u7bb1\u6210\u529f");
    }

    @Generated
    public EmailValidateController(EmailUtil emailUtil, RedisTemplateHelper redisTemplateHelper, UserService userService, IpInfoUtil ipInfoUtil, SettingService settingService, SecurityUtil securityUtil) {
        this.emailUtil = emailUtil;
        this.redisTemplateHelper = redisTemplateHelper;
        this.userService = userService;
        this.ipInfoUtil = ipInfoUtil;
        this.settingService = settingService;
        this.securityUtil = securityUtil;
    }
}

