/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.system.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.base.HiverBaseController;
import plus.hiver.common.base.HiverBaseService;
import plus.hiver.common.constant.HiverConstant;
import plus.hiver.common.entity.Tenant;
import plus.hiver.common.service.TenantService;
import plus.hiver.common.utils.PageUtil;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.vo.PageVo;
import plus.hiver.common.vo.SearchVo;

@RestController
@Tag(name="\u79df\u6237\u7ba1\u7406\u63a5\u53e3")
@PermissionTag(permission="tenant:*")
@RequestMapping(value={"/hiver/tenant"})
@Transactional
public class TenantController
extends HiverBaseController<Tenant, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantController.class);
    @Resource
    private TenantService tenantService;

    public HiverBaseService<Tenant, Long> getService() {
        return this.tenantService;
    }

    @GetMapping(value={"/getByCondition"})
    @Operation(summary="\u591a\u6761\u4ef6\u5206\u9875\u83b7\u53d6")
    public Result<Page<Tenant>> getByCondition(Tenant tenant, SearchVo searchVo, PageVo pageVo) {
        Page page = this.tenantService.findByCondition(tenant, searchVo, PageUtil.initPage((PageVo)pageVo));
        return new ResultUtil().setData((Object)page);
    }

    @GetMapping(value={"/getTenant/{name}"})
    @Operation(summary="\u901a\u8fc7\u540d\u79f0\u83b7\u53d6\u79df\u6237\u6570\u636e")
    public Result<Tenant> getTenant(@PathVariable String string) {
        Tenant tenant = this.tenantService.findByName(string);
        return new ResultUtil().setData((Object)tenant);
    }

    @GetMapping(value={"/getAll"})
    @Operation(summary="\u83b7\u53d6\u5168\u90e8\u79df\u6237\u6570\u636e")
    public Result<List<Tenant>> getAll() {
        List list = this.tenantService.findByStatusAndDeleted(HiverConstant.STATUS_NORMAL, Integer.valueOf(0));
        return new ResultUtil().setData((Object)list);
    }

    @Generated
    public TenantController(TenantService tenantService) {
        this.tenantService = tenantService;
    }
}

