/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.module.system.dao;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import plus.hiver.common.base.HiverBaseDao;
import plus.hiver.module.system.entity.DictData;

import java.util.List;

/**
 * 字典数据数据处理层
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Repository
public interface DictDataDao extends HiverBaseDao<DictData, Long> {
    /**
     * 通过dictId和状态获取
     *
     * @param dictId  字典ID
     * @param status  状态
     * @return  字典数据列表
     */
    List<DictData> findByDictIdAndStatusOrderBySortOrder(Long dictId, Integer status);

    /**
     * 通过dictId删除
     *
     * @param dictId  字典ID
     */
    @Modifying
    @Query("delete from DictData d where d.dictId = ?1")
    void deleteByDictId(Long dictId);

    /**
     * 通过dictId和值获取
     *
     * @param dictId 字典ID
     * @param value 字典值
     * @return 字典数据
     */
    DictData findByDictIdAndValue(Long dictId, String value);
}
