/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.system.controller;

import cn.hutool.core.util.StrUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.annotation.SystemLog;
import plus.hiver.common.api.Result;
import plus.hiver.common.base.HiverBaseEntity;
import plus.hiver.common.config.properties.HiverTokenProperties;
import plus.hiver.common.constant.UserConstant;
import plus.hiver.common.entity.Role;
import plus.hiver.common.entity.User;
import plus.hiver.common.entity.UserRole;
import plus.hiver.common.enums.LogType;
import plus.hiver.common.exception.HiverException;
import plus.hiver.common.redis.RedisTemplateHelper;
import plus.hiver.common.service.RoleService;
import plus.hiver.common.service.UserRoleService;
import plus.hiver.common.service.UserService;
import plus.hiver.common.utils.NameUtil;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.utils.SecurityUtil;
import plus.hiver.module.system.async.AddMessage;

@RestController
@Tag(name="\u7528\u6237\u8ba4\u8bc1\u76f8\u5173\u63a5\u53e3")
@PermissionTag(permission="auth:*")
@RequestMapping(value={"/hiver/auth"})
@CacheConfig(cacheNames={"user"})
@Transactional
public class AuthController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthController.class);
    public static final String USER = "username::";
    public static final String LOGIN_FAIL_FLAG = "LOGIN_FAIL_FLAG:";
    public static final String LOGIN_TIME_LIMIT = "LOGIN_TIME_LIMIT:";
    public static final Integer LOGIN_FAIL_TIP_TIME = 3;
    @Resource
    private UserService userService;
    @Resource
    private RoleService roleService;
    @Resource
    private UserRoleService userRoleService;
    @Resource
    private AddMessage addMessage;
    @Resource
    private HiverTokenProperties tokenProperties;
    @Resource
    private SecurityUtil securityUtil;
    @Resource
    private RedisTemplateHelper redisTemplateHelper;

    @PostMapping(value={"/login"})
    @SystemLog(description="\u8d26\u53f7\u767b\u5f55", type=LogType.LOGIN)
    @Operation(summary="\u8d26\u53f7/\u624b\u673a/\u90ae\u7bb1\u767b\u5f55")
    public Result login(@RequestParam String string, @RequestParam String string2, @RequestParam(required=false) Boolean bl, @RequestParam(required=false) Long l) {
        String string3 = LOGIN_FAIL_FLAG + string;
        String string4 = LOGIN_TIME_LIMIT + string;
        String string5 = this.redisTemplateHelper.get(string3);
        Long l2 = this.redisTemplateHelper.getExpire(string3, TimeUnit.MINUTES);
        if (StrUtil.isNotBlank((CharSequence)string5)) {
            return ResultUtil.error((String)("\u767b\u5f55\u9519\u8bef\u6b21\u6570\u8d85\u8fc7\u9650\u5236\uff0c\u8bf7" + l2 + "\u5206\u949f\u540e\u518d\u8bd5"));
        }
        User user = this.securityUtil.checkUserPassword(string, string2);
        if (user == null) {
            int n;
            String string6 = this.redisTemplateHelper.get(string4);
            if (StrUtil.isBlank((CharSequence)string6)) {
                string6 = "0";
            }
            Integer n2 = Integer.parseInt(string6) + 1;
            this.redisTemplateHelper.set(string4, n2.toString(), (long)this.tokenProperties.getLoginAfterTime().intValue(), TimeUnit.MINUTES);
            if (n2 >= this.tokenProperties.getLoginTimeLimit()) {
                this.redisTemplateHelper.set(string3, "FAIL", (long)this.tokenProperties.getLoginAfterTime().intValue(), TimeUnit.MINUTES);
            }
            if ((n = this.tokenProperties.getLoginTimeLimit() - n2) > 0 && n <= LOGIN_FAIL_TIP_TIME) {
                return ResultUtil.error((String)("\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8fd8\u6709" + n + "\u6b21\u5c1d\u8bd5\u673a\u4f1a"));
            }
            if (n <= 0) {
                return ResultUtil.error((String)("\u767b\u5f55\u9519\u8bef\u6b21\u6570\u8d85\u8fc7\u9650\u5236\uff0c\u8bf7" + this.tokenProperties.getLoginAfterTime() + "\u5206\u949f\u540e\u518d\u8bd5"));
            }
            return ResultUtil.error((String)"\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef");
        }
        if (!Objects.equals(user.getTenantId(), l)) {
            return ResultUtil.error((String)"\u79df\u6237\u4e0e\u7528\u6237\u4e0d\u5339\u914d");
        }
        String string7 = "Bearer " + this.securityUtil.getToken(user, bl);
        return ResultUtil.data((Object)string7);
    }

    @PostMapping(value={"/smsLogin"})
    @SystemLog(description="\u77ed\u4fe1\u767b\u5f55", type=LogType.LOGIN)
    @Operation(summary="\u77ed\u4fe1\u767b\u5f55")
    public Result smsLogin(@RequestParam String string, @RequestParam(required=false) Boolean bl, @RequestParam(required=false) Long l) {
        User user = this.userService.findByMobile(string);
        if (user == null) {
            throw new HiverException("\u624b\u673a\u53f7\u4e0d\u5b58\u5728");
        }
        if (!Objects.equals(user.getTenantId(), l)) {
            return ResultUtil.error((String)"\u79df\u6237\u4e0e\u7528\u6237\u4e0d\u5339\u914d");
        }
        String string2 = this.securityUtil.getToken(user, bl);
        return ResultUtil.data((Object)string2);
    }

    @PostMapping(value={"/register"})
    @Operation(summary="\u6ce8\u518c\u7528\u6237")
    public Result register(@Valid User user) {
        NameUtil.checkUserInfo((User)user);
        String string = user.getMobile().substring(0, 3) + "****" + user.getMobile().substring(7, 11);
        String string2 = new BCryptPasswordEncoder().encode((CharSequence)user.getPassword());
        user.setPassword(string2);
        user.setType(UserConstant.USER_TYPE_NORMAL);
        user.setNickname(string);
        User user2 = (User)this.userService.save((HiverBaseEntity)user);
        List list = this.roleService.findByDefaultRole(Boolean.valueOf(true));
        if (list != null && list.size() > 0) {
            for (Role role : list) {
                UserRole userRole = new UserRole();
                userRole.setUserId(user2.getId());
                userRole.setRoleId(role.getId());
                this.userRoleService.save((HiverBaseEntity)userRole);
            }
        }
        this.addMessage.addSendMessage(user2.getId());
        return ResultUtil.data((Object)user2);
    }

    @PostMapping(value={"/resetByMobile"})
    @Operation(summary="\u901a\u8fc7\u77ed\u4fe1\u91cd\u7f6e\u5bc6\u7801")
    public Result resetByMobile(@RequestParam String string, @RequestParam String string2, @RequestParam String string3) {
        User user = this.userService.findByMobile(string);
        String string4 = new BCryptPasswordEncoder().encode((CharSequence)string2);
        user.setPassword(string4).setPassStrength(string3);
        this.userService.update((HiverBaseEntity)user);
        this.redisTemplateHelper.delete(USER + user.getUsername());
        return ResultUtil.success((String)"\u91cd\u7f6e\u5bc6\u7801\u6210\u529f");
    }

    @PostMapping(value={"/resetByEmail"})
    @Operation(summary="\u901a\u8fc7\u90ae\u7bb1\u91cd\u7f6e\u5bc6\u7801")
    public Result resetByEmail(@RequestParam String string, @RequestParam String string2, @RequestParam String string3) {
        User user = this.userService.findByEmail(string);
        String string4 = new BCryptPasswordEncoder().encode((CharSequence)string2);
        user.setPassword(string4);
        user.setPassStrength(string3);
        this.userService.update((HiverBaseEntity)user);
        this.redisTemplateHelper.delete("user::" + user.getUsername());
        return ResultUtil.success((String)"\u91cd\u7f6e\u5bc6\u7801\u6210\u529f");
    }

    @PostMapping(value={"/logout"})
    @Operation(summary="\u7528\u6237\u6ce8\u9500")
    public Result logout() {
        try {
            User user = this.securityUtil.getCurrUser();
            this.redisTemplateHelper.delete(USER + user.getUsername());
            String string = this.redisTemplateHelper.get("HIVER_USER_TOKEN:" + user.getUsername());
            this.redisTemplateHelper.delete("ONLINE_USER:" + user.getUsername() + ":" + string);
            this.redisTemplateHelper.delete("HIVER_TOKEN_PRE:" + string);
            this.redisTemplateHelper.delete("HIVER_USER_TOKEN:" + user.getUsername());
            this.redisTemplateHelper.delete("HIVER_TENANT_TOKEN:" + user.getUsername());
        }
        catch (Exception exception) {
            log.error("\u7528\u6237\u6ce8\u9500\u5f02\u5e38", (Throwable)exception);
        }
        return ResultUtil.success((String)"\u6ce8\u9500\u6210\u529f");
    }

    @Generated
    public AuthController(UserService userService, RoleService roleService, UserRoleService userRoleService, AddMessage addMessage, HiverTokenProperties hiverTokenProperties, SecurityUtil securityUtil, RedisTemplateHelper redisTemplateHelper) {
        this.userService = userService;
        this.roleService = roleService;
        this.userRoleService = userRoleService;
        this.addMessage = addMessage;
        this.tokenProperties = hiverTokenProperties;
        this.securityUtil = securityUtil;
        this.redisTemplateHelper = redisTemplateHelper;
    }
}

