/*
 * Decompiled with CFR 0.152.
 */
package plus.hiver.module.system.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.base.HiverBaseEntity;
import plus.hiver.common.constant.HiverConstant;
import plus.hiver.common.entity.Tenant;
import plus.hiver.common.service.TenantService;
import plus.hiver.common.service.UserService;
import plus.hiver.common.utils.PageUtil;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.common.utils.SecurityUtil;
import plus.hiver.common.vo.PageVo;
import plus.hiver.common.vo.SearchVo;

@RestController
@Tag(name="\u79df\u6237\u7ba1\u7406\u63a5\u53e3")
@PermissionTag(permission="tenant:*")
@RequestMapping(value={"/hiver/tenant"})
@Transactional
public class TenantController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantController.class);
    @Resource
    private TenantService tenantService;
    @Resource
    private UserService userService;
    @Resource
    private SecurityUtil securityUtil;

    @GetMapping(value={"/getByCondition"})
    @Operation(summary="\u591a\u6761\u4ef6\u5206\u9875\u83b7\u53d6")
    public Result<Page<Tenant>> getByCondition(Tenant tenant, SearchVo searchVo, PageVo pageVo) {
        Page page = this.tenantService.findByCondition(tenant, searchVo, PageUtil.initPage((PageVo)pageVo));
        return new ResultUtil().setData((Object)page);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u6dfb\u52a0\u79df\u6237")
    public Result add(@Valid @RequestBody Tenant tenant) {
        if (this.tenantService.findByName(tenant.getName()) != null) {
            return ResultUtil.error((String)"\u79df\u6237\u5df2\u5b58\u5728");
        }
        this.tenantService.save((HiverBaseEntity)tenant);
        return ResultUtil.success((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @PostMapping(value={"/edit"})
    @Operation(summary="\u7f16\u8f91\u79df\u6237")
    public Result edit(@Valid @RequestBody Tenant tenant) {
        this.tenantService.update((HiverBaseEntity)tenant);
        return ResultUtil.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @PostMapping(value={"/status"})
    @Operation(summary="\u4fee\u6539\u79df\u6237\u72b6\u6001")
    public Result disable(@RequestParam Long l, @RequestParam Boolean bl) {
        Tenant tenant = (Tenant)this.tenantService.get(l);
        if (bl.booleanValue()) {
            tenant.setStatus(HiverConstant.STATUS_NORMAL);
        } else {
            tenant.setStatus(HiverConstant.STATUS_DISABLE);
        }
        this.tenantService.update((HiverBaseEntity)tenant);
        return ResultUtil.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/delByIds"})
    @Operation(summary="\u6279\u91cf\u901a\u8fc7ids\u5220\u9664")
    public Result delAllByIds(@RequestParam Long[] longArray) {
        for (Long l : longArray) {
            Long l2 = this.userService.countByTenantId(l);
            if (l2 > 0L) {
                return ResultUtil.error((String)"\u8be5\u79df\u6237\u4e0b\u6709\u7528\u6237\uff0c\u8bf7\u5148\u5220\u9664\u7528\u6237");
            }
            if (l.equals(HiverConstant.DEFAULT_TENANT_ID)) {
                return ResultUtil.error((String)"\u7cfb\u7edf\u79df\u6237\u4e0d\u5141\u8bb8\u5220\u9664");
            }
            this.tenantService.delete(l);
        }
        return ResultUtil.success((String)"\u6279\u91cf\u901a\u8fc7id\u5220\u9664\u6570\u636e\u6210\u529f");
    }

    @GetMapping(value={"/info"})
    @Operation(summary="\u83b7\u5f97\u79df\u6237\u4fe1\u606f")
    public Result<Tenant> info() {
        Long l = this.securityUtil.getCurrUser().getTenantId();
        Tenant tenant = (Tenant)this.tenantService.get(l);
        return ResultUtil.data((Object)tenant);
    }

    @GetMapping(value={"/getAll"})
    @Operation(summary="\u83b7\u53d6\u5168\u90e8\u79df\u6237\u6570\u636e")
    public Result<List<Tenant>> getAll() {
        List list = this.tenantService.findByStatusAndDeleted(HiverConstant.STATUS_NORMAL, Integer.valueOf(0));
        return new ResultUtil().setData((Object)list);
    }

    @Generated
    public TenantController(TenantService tenantService, UserService userService, SecurityUtil securityUtil) {
        this.tenantService = tenantService;
        this.userService = userService;
        this.securityUtil = securityUtil;
    }
}

