/*
 * Copyright 2023-2025 Licensed under the AGPL License
 */
package plus.hiver.tess4j.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import plus.hiver.common.annotation.PermissionTag;
import plus.hiver.common.api.Result;
import plus.hiver.common.utils.ResultUtil;
import plus.hiver.tess4j.service.OCRService;

/**
 * OCR控制器
 *
 * <p>
 * 尊重知识产权，CV 请保留版权，海文科技 https://hiver.cc 出品，不允许非法使用，后果自负
 * </p>
 *
 * @author Yazhi Li
 */
@Slf4j
@RestController
@Tag(name = "OCR文本识别管理接口")
@PermissionTag(permission = "ocr:*" )
@AllArgsConstructor
@RequestMapping("/hiver/ocr")
public class OCRController {
    @Resource
    private OCRService ocrService;

    @PostMapping(value = "/recognize")
    @Operation(summary = "文件识别")
    public Result upload(@RequestParam MultipartFile file,
                         @RequestParam(defaultValue = "chi_sim") String language) {
        try {
            String result = ocrService.doOCR(file, language);
            return ResultUtil.data(result);
        } catch (Exception e) {
            log.error("OCR识别失败", e);
            return ResultUtil.error("OCR识别失败: " + e.getMessage());
        }
    }
}
