package plus.ibatis.hbatis.core;

import java.util.ArrayList;
import java.util.List;

import plus.ibatis.hbatis.core.meta.EntityMeta;
import plus.ibatis.hbatis.core.metaDescriber.EntityClassDescriber;
import plus.ibatis.hbatis.core.metaDescriber.EntityFieldDescriber;
import plus.ibatis.hbatis.core.util.EntityClassDescriberHelper;

public abstract class AbstractEntityNode<E> implements EntityNode<E> {
	
	private String alias;

	private List<FieldNode<E, ?>> fieldPaths = new ArrayList<>();

	private EntityClassDescriber<E> describer = null;
	
	public AbstractEntityNode(Class<E> entityClass, String alias) {
		this.alias = alias;
		
		describer = EntityClassDescriberHelper.getEntityClassDescriber(entityClass);
		
	}
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static <E> AbstractEntityNode<E> of(Class<E> entityClass) {
		AbstractEntityNode<E> n = new AbstractEntityNode(entityClass,null) {};
		List<EntityFieldDescriber> fields = n.describer.getFieldDescribers();
		for(EntityFieldDescriber f:fields) {
//			if(f.getFieldMeta().isNormalType()) {
				n.ref(f.getFieldName());
//			}
		}
		return n;
	}
	protected <K> FieldNode<E, K> ref(String propName) {
		return createFieldNode(propName);

	}
	
	protected <K> FieldNode<E, K> createFieldNode(String propName) {
		try {
			FieldNode<E, K> fp = new AbstractFieldNode<E, K>(this, propName) {
	
			};
			long count = this.fieldPaths.stream().filter(tmp->tmp.getPropertyName().equals(propName)).count();
			if(count < 1) this.fieldPaths.add(fp);
			return fp;
		} catch (Exception e) {
			throw new RuntimeException("Create FieldNode error[prop:"+propName+"]",e);
		}
	}

	@SuppressWarnings("unchecked")
	public FieldNode<E,?> getFieldNode(String propName){
		FieldNode<E,?> fn = this.fieldPaths.stream().filter(tmp->tmp.getPropertyName().equals(propName)).findFirst().orElse(null);
		if(fn == null) {
			throw new IllegalArgumentException("Property ["+propName+"] not found");
		}
		return fn;
	}
	public EntityMeta<E> getEntityMeta() {
		return describer.getEntityMeta();
	}

	public String getSqlTable() {
		String name = getEntityMeta().getTableName().replaceAll("`", "");
		name = "`"+name+"`";
		if (getAlias() != null)
			name = String.valueOf(name) + " " + getAlias();
		return name;
	}

	public String getAlias() {
		return this.alias;
	}

	public List<FieldNode<E, ?>> getFieldNodes() {
		return this.fieldPaths;
	}
	public String getSqlColumns() {
		StringBuilder sb = new StringBuilder();
		for(FieldNode<E,?> fm:this.fieldPaths) {
//			if(fm.getFieldMeta().isNormalType()) {
				sb.append("`").append(fm.getFieldMeta().getColumnName()).append("`,");
//			}
		}
		return sb.length()>0?sb.deleteCharAt(sb.length()-1).toString():"";
	}
	
}
