package plus.ibatis.hbatis.core;

import java.util.List;

import plus.ibatis.hbatis.core.meta.FieldMeta;
import plus.ibatis.hbatis.core.metaDescriber.EntityFieldDescriber;
import plus.ibatis.hbatis.core.util.EntityClassDescriberHelper;

public abstract class AbstractFieldNode<E,T> implements FieldNode<E,T> {
	private EntityNode<E> entityPath;
	private EntityFieldDescriber fieldDescriber ;
	public AbstractFieldNode(EntityNode<E> entityPath, String propName) {
		this.entityPath = entityPath;
		Class<E> entityClass = this.entityPath.getEntityMeta().getEntityClass();
		List<EntityFieldDescriber> fieldDescribers = EntityClassDescriberHelper.getEntityClassDescriber(entityClass).getFieldDescribers();
		fieldDescriber = fieldDescribers.stream().filter(r->r.getFieldMeta().getPropertyName().equals(propName)).findFirst()
				  .orElseThrow(()->new RuntimeException("No property "+propName+" in "+entityClass));
		
	}
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static <E,T> AbstractFieldNode of(EntityNode<E> entityPath,String propName) {
		return new AbstractFieldNode(entityPath,propName) {};
	}
	public String getPropertyName(){
		return this.fieldDescriber.getFieldName();
	}
	public String getSqlColumn(){
		String name = fieldDescriber.getFieldMeta().getColumnName().replaceAll("`", "");
		if(entityPath.getAlias()!=null) {
			name = entityPath.getAlias()+".`"+name+"`";
		}
		return name;
	}
	@SuppressWarnings("unchecked")
	public FieldMeta<E,T> getFieldMeta(){
		return this.fieldDescriber.getFieldMeta();
	}
	@Override
	public EntityNode<E> getEntityPath(){
		return this.entityPath;
	}

	@Override
	public Criterion<E,T> eq(T value) {
		return new Criterion<E,T>(this,CriterionOpts.EQ,value);
	}

	@Override
	public Criterion<E,T> ne(T value) {
		return new Criterion<E,T>(this,CriterionOpts.NE,value);
	}

	@Override
	public Criterion<E,T> gt(T value) {
		return new Criterion<E,T>(this,CriterionOpts.GT,value);
	}

	@Override
	public Criterion<E,T> ge(T value) {
		return new Criterion<E,T>(this,CriterionOpts.GE,value);
	}

	@Override
	public Criterion<E,T> lt(T value) {
		return new Criterion<E,T>(this,CriterionOpts.LT,value);
	}
	@Override
	public Criterion<E,T> le(T value) {
		return new Criterion<E,T>(this,CriterionOpts.LE,value);
	}
	@Override
	public Criterion<E,T> isNull() {
		T t = null;
		return new Criterion<E,T>(this,CriterionOpts.IS,t);
	}

	@Override
	public Criterion<E,T> isNotNull() {
		T t = null;
		return new Criterion<E,T>(this,CriterionOpts.NIS,t);
	}
	public Criterion<E,T> between(T value0,T value1){
		return new Criterion<E,T>(this,CriterionOpts.BETWEEN, value0,value1);
	}
	public Criterion<E,T> notBetween(T value0,T value1){
		return new Criterion<E,T>(this,CriterionOpts.NBETWEEN,value0,value1);
	}
	
	public Criterion<E,T> in(List<T> list){
		return new Criterion<E,T>(this,CriterionOpts.IN,list);
	}
	public Criterion<E,T> notIn(List<T> list){
		return new Criterion<E,T>(this,CriterionOpts.NIN,list);
	}
	
	public Criterion<E,T> like(T value){
		return new Criterion<E,T>(this,CriterionOpts.LIKE,value);
	}
	
	public Criterion<E,T> notLike(T value){
		return new Criterion<E,T>(this,CriterionOpts.NLIKE,value);
	}

	@Override
	public Criterion<E, T> gt(FieldNode<E, T> a) {
		return new Criterion<E,T>(this,CriterionOpts.GT,a);
	}

	@Override
	public Criterion<E, T> eq(FieldNode<E, T> a) {
		return new Criterion<E,T>(this,CriterionOpts.EQ,a);
	}

	@Override
	public Criterion<E, T> ne(FieldNode<E, T> a) {
		return new Criterion<E,T>(this,CriterionOpts.NE,a);
	}

	@Override
	public Criterion<E, T> lt(FieldNode<E, T> a) {
		return new Criterion<E,T>(this,CriterionOpts.LT,a);
	}

	@Override
	public Criterion<E, T> le(FieldNode<E, T> a) {
		return new Criterion<E,T>(this,CriterionOpts.LE,a);
	}

	@Override
	public Criterion<E, T> ge(FieldNode<E, T> a) {
		return new Criterion<E,T>(this,CriterionOpts.GE,a);
	}
	@Override
	public Criterion<E, T> regexp(T value) {
		return new Criterion<E,T>(this,CriterionOpts.REGEXP,value);
	}
	@Override
	public Criterion<E, T> sql(CriterionOpts opt,String sql) {
		if(CriterionOpts.BETWEEN.equals(opt) || CriterionOpts.NBETWEEN.equals(opt)) {
			throw new IllegalArgumentException("Not support between operation by sql.");
		}
		Criterion<E,T> c = new Criterion<E,T>(this,opt);
		c.setSqlValue(sql);
		return c;
	}
}
