package plus.ibatis.hbatis.core;

import java.util.List;

/**
 * Criterion
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class Criterion<E,T> {
	
	private FieldNode<E,T> fieldNode = null;
	/**
	 * list of value
	 */
	private List<T> values;
	/**
	 * single value
	 */
	private T value;
	/**
	 * two values(for between)
	 */
	private T secondValue;
	private boolean singleValue;
	private boolean betweenValue;
	private boolean listValue;
	
	private FieldNode<E,T> valueNode = null;
	
	private String sqlValue;
	/**
	 * 操作符
	 */
	private CriterionOpts opt;
	
	public Criterion(FieldNode<E,T> fp,CriterionOpts opt){
		this.fieldNode = fp;
		this.opt = opt;
		
	}
	public Criterion(FieldNode<E,T> fp,CriterionOpts opt,T value) {
		this(fp,opt);
		this.value = value;
		this.singleValue = true;
		
	}

	public Criterion(FieldNode<E,T> fp, CriterionOpts opt, T value0, T value1) {
		this(fp,opt);
		this.value = value0;
		this.secondValue = value1;
		this.betweenValue = true;
	}

	public Criterion(FieldNode<E,T> fp, CriterionOpts opt, List<T> list) {
		this(fp,opt);
		this.values = list;
		this.listValue = true;
	}

	public Criterion(FieldNode<E, T> fp,CriterionOpts opt, FieldNode<E, T> valueNode) {
		this(fp,opt);
		this.singleValue = true;
		this.valueNode = valueNode;
	}
	
	public FieldNode<E, T> getValueNode() {
		return valueNode;
	}
	public FieldNode<E,T> getFieldNode() {
		return fieldNode;
	}
	public String getOpKey() {
		return this.opt.getKey();
	}
	/**
	 * 获取SQL操作符
	 * @return operation string
	 */
	public String getOper() {
		return this.opt.getValue();
	}

	public List<T> getValues() {
		return values;
	}

	public T getValue() {
		return value;
	}
	public boolean isNullValue() {
		return CriterionOpts.IS.equals(this.opt) || CriterionOpts.NIS.equals(this.opt);
	}
	public boolean isNodeValue() {
		return valueNode!=null;
	}
	public boolean isSingleValue() {
		return singleValue;
	}

	public boolean isBetweenValue() {
		return betweenValue;
	}

	public boolean isListValue() {
		return listValue;
	}

	public T getSecondValue() {
		return secondValue;
	}
	public String getSqlValue() {
		return sqlValue;
	}
	public void setSqlValue(String sqlValue) {
		this.sqlValue = sqlValue;
	}
	

	
}
