package plus.ibatis.hbatis.core;

/**
 * Criterion operations
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public enum CriterionOpts {

	EQ("eq", "="), NE("ne", "<>"), GT("gt", ">"), GE("ge", ">="), LT("lt", "<"), LE("le", "<="), IN("in", "in", true),
	NIN("nin", "not in", true), LIKE("like", "like"), NLIKE("nlike", "not like"), IS("is", "is"), NIS("nis", "is not"),
	BETWEEN("between", "between", true), NBETWEEN("nbetween", "not between", true), REGEXP("regexp", "regexp"),
	EXISTS("exists","exists"),NEXISTS("nexists","not exists");

	private String key;
	private String value;
	private boolean isValueCollection;

	CriterionOpts(String key, String value) {
		this(key,value,false);
	}

	CriterionOpts(String key, String value, boolean isCol) {
		this.key = key;
		this.value = value;
		this.isValueCollection = isCol;
	}

	public String getKey() {
		return key;
	}

	public String getValue() {
		return value;
	}

	public boolean isValueCollection() {
		return isValueCollection;
	}

	public static CriterionOpts match(String str) {
		CriterionOpts[] enums = CriterionOpts.values();
		for (CriterionOpts anEnum : enums) {
			if (anEnum.getKey().equals(str)) {
				return anEnum;
			}
		}
		return null;
	}
}
