package plus.ibatis.hbatis.core;

import java.util.List;

import plus.ibatis.hbatis.core.meta.EntityMeta;
/**
 * entity node
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public interface EntityNode<T> {
	/**
	 * entity meta
	 * @return EntityMeta
	 */
	EntityMeta<T> getEntityMeta();
	/**
	 * alias
	 * @return alias
	 */
	String getAlias();
	/**
	 * contain alias,such as:table_a a
	 * @return sql table
	 */
	String getSqlTable();
	
	/**
	 * field nodes
	 * @return fieldnodes
	 */
	List<FieldNode<T,?>> getFieldNodes();
	
	/**
	 * sql columns
	 * @return sql columns
	 */
	String getSqlColumns();
	
	/**
	 * get field node
	 * @param <V> value type
	 * @param propName property name
	 * @return FieldNode
	 */
	<V> FieldNode<T,V> getFieldNode(String propName);
}
