package plus.ibatis.hbatis.core;


import java.util.List;

/**
 * Restriction
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public interface Restriction<E,T> {
	/**
	 * equal
	 * @param value
	 * 			a value
	 * @return Criterion
	 */
	Criterion<E,T> eq(T value);
	/**
	 * not equal
	 * @param value
	 * 			a value
	 * @return Criterion
	 */
	Criterion<E,T> ne(T value);
	/**
	 * greater than
	 * @param value
	 * 			a value
	 * @return Criterion
	 */
	Criterion<E,T> gt(T value);
	/**
	 * greater than or equal
	 * @param value
	 * 			a value
	 * @return Criterion
	 */
	Criterion<E,T> ge(T value);
	/**
	 * less than
	 * @param value
	 * 			a value
	 * @return Criterion
	 */
	Criterion<E,T> lt(T value);
	/**
	 * less than or equal
	 * @param value
	 * 			a value
	 * @return Criterion
	 */
	Criterion<E,T> le(T value);
	
	/**
	 * is null
	 * @return Criterion
	 */
	Criterion<E,T> isNull();
	/**
	 * is not null
	 * @return Criterion
	 */
	Criterion<E,T> isNotNull();
	/**
	 * between(ge and le)
	 * @param value1
	 * 			a value
	 * @param value2
	 * 			a value
	 * @return Criterion
	 */
	Criterion<E,T> between(T value1,T value2);
	/**
	 * not between
	 * @param value1
	 * 			a value
	 * @param value2
	 * 			a value
	 * @return Criterion
	 */
	Criterion<E,T> notBetween(T value1,T value2);
	/**
	 * in
	 * @param list
	 * 			list of value
	 * @return Criterion
	 */
	Criterion<E,T> in(List<T> list);
	/**
	 * not in
	 * @param list
	 * 			list of value
	 * @return Criterion
	 */
	Criterion<E,T> notIn(List<T> list);
	
	/**
	 * like
	 * @param value
	 * 			a value,such as '%xxx%'
	 * @return Criterion
	 */
	Criterion<E,T> like(T value);
	
	/**
	 * not like
	 * @param value
	 * 			a value,such as '%xxx%'
	 * @return Criterion
	 */
	Criterion<E,T> notLike(T value);
	
	/**
	 * regexp
	 * @param value
	 * 			a regex value
	 * @return Criterion
	 */
	Criterion<E,T> regexp(T value);
	
	/**
	 * sql
	 * @param opt
	 * 			CriterionOpts
	 * @param sql
	 * 			orign sql 
	 * @return Criterion
	 */
	Criterion<E,T> sql(CriterionOpts opt, String sql);
}
