package plus.ibatis.hbatis.core.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import plus.ibatis.hbatis.core.type.JdbcType;

@Target({ ElementType.FIELD })
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Column {
	
	/**
	 * 名称
	 * @return 名称
	 */
	String name() default "";
	/**
	 * 可更新字段
	 * 
	 * @return 可更新字段
	 */
	boolean updatable() default true;

	/**
	 * 注释
	 * 
	 * @return 注释
	 */
	String comment() default "";

	/**
	 * 是否可为空
	 * @return 是否可为空
	 */
	boolean nullable() default true;
	
	/**
	 * 是否可插入
	 * @return 是否可插入
	 */
	boolean insertable() default true;
	
	/**
	 * 长度
	 * @return 长度
	 */
	int length() default 255;
	
	/**
	 * jdbc 类型
	 * @return JDBC类型
	 */
	JdbcType jdbcType() default JdbcType.NULL;
}
