package plus.ibatis.hbatis.core.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import plus.ibatis.hbatis.core.IdStrategy;

@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.FIELD})
@Documented
public @interface Id {

	/**
	 * 策略
	 * @return IdStrategy
	 */
	IdStrategy strategy() default IdStrategy.AUTO;
	
	/**
	 * 策略实现类
	 * @return strategyClass
	 */
	@SuppressWarnings("rawtypes")
	Class strategyClass() default Void.class;
}
