package plus.ibatis.hbatis.core.meta;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import plus.ibatis.hbatis.core.IdStrategy;
import plus.ibatis.hbatis.core.type.JdbcType;

/**
 * field meta
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class FieldMeta<E, T> {
	private EntityMeta<E> entityMeta;

	private Class<T> fieldType;

	private String columnName;

	private String propertyName;

	private JdbcType jdbcType;

	private boolean primaryKey;

	private boolean insertable = true;
	private boolean updatable = true;
	
	private boolean nullable = true;
	
	private boolean indexed = false;
	private int length;
	
	/**
	 * comment
	 */
	private String comment ;
	/***
	 * id strategy
	 */
	private IdStrategy idStrategy;
	
	@SuppressWarnings("rawtypes")
	private Class idStrategyClass;
	
	public FieldMeta(EntityMeta<E> entityMeta, Class<T> clazz, String propName, String columnName) {
		this.entityMeta = entityMeta;
		this.fieldType = clazz;
		this.columnName = columnName;
		this.propertyName = propName;
	}

	public EntityMeta<?> getEntityMeta() {
		return this.entityMeta;
	}

	public Class<T> getFieldType() {
		return this.fieldType;
	}

	public String getColumnName() {
		return this.columnName;
	}

	public JdbcType getJdbcType() {
		return this.jdbcType;
	}

	public void setJdbcType(JdbcType jdbcType) {
		this.jdbcType = jdbcType;
	}

	public String getPropertyName() {
		return this.propertyName;
	}

	public boolean isPrimaryKey() {
		return this.primaryKey;
	}

	public void setPrimaryKey(boolean primaryKey) {
		this.primaryKey = primaryKey;
	}

	public boolean isUpdatable() {
		return this.updatable;
	}

	public void setUpdatable(boolean updatable) {
		this.updatable = updatable;
	}

	public boolean isInsertable() {
		return insertable;
	}

	public void setInsertable(boolean insertable) {
		this.insertable = insertable;
	}

	public IdStrategy getIdStrategy() {
		return idStrategy;
	}

	public void setIdStrategy(IdStrategy idStrategy) {
		this.idStrategy = idStrategy;
	}

	public boolean isAutoIncrement() {
		return IdStrategy.IDENTITY.equals(idStrategy);
	}

	public int getLength() {
		return length;
	}

	public void setLength(int length) {
		this.length = length;
	}

	public boolean isNullable() {
		return nullable;
	}

	public void setNullable(boolean nullable) {
		this.nullable = nullable;
	}

	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public boolean isIndexed() {
		return indexed;
	}

	public void setIndexed(boolean indexed) {
		this.indexed = indexed;
	}
	
	@SuppressWarnings("rawtypes")
	public Class getIdStrategyClass() {
		return idStrategyClass;
	}

	@SuppressWarnings("rawtypes")
	public void setIdStrategyClass(Class idStrategyClass) {
		this.idStrategyClass = idStrategyClass;
	}

	private static Set<Class<?>> normalTypes = new HashSet<Class<?>>();
	static {
		normalTypes.add(String.class);
		
		normalTypes.add(Number.class);
		normalTypes.add(int.class);
		normalTypes.add(long.class);
		normalTypes.add(double.class);
		normalTypes.add(float.class);
		
		normalTypes.add(Boolean.class);
		normalTypes.add(boolean.class);
		
		normalTypes.add(Byte.class);
		normalTypes.add(Date.class);
		normalTypes.add(Character.class);
		normalTypes.add(char.class);
	}
	public boolean isNormalType() {
		
		for(Class<?> r:normalTypes) {
			if(r.isAssignableFrom(this.fieldType)) {
				return true;
			}
		}
		return false;
	}
	
}
