package plus.ibatis.hbatis.core.metaDescriber.adapter;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import plus.ibatis.hbatis.core.annotation.Column;
import plus.ibatis.hbatis.core.annotation.Id;
import plus.ibatis.hbatis.core.annotation.Indexed;
import plus.ibatis.hbatis.core.annotation.Table;
import plus.ibatis.hbatis.core.exception.UnknownJdbcTypeException;
import plus.ibatis.hbatis.core.meta.EntityMeta;
import plus.ibatis.hbatis.core.meta.FieldMeta;
import plus.ibatis.hbatis.core.metaDescriber.EntityClassDescriber;
import plus.ibatis.hbatis.core.metaDescriber.EntityFieldDescriber;
import plus.ibatis.hbatis.core.metaDescriber.IEntityClassReader;
import plus.ibatis.hbatis.core.type.JdbcType;
import plus.ibatis.hbatis.core.util.DefaultJdbcTypeRegistry;

public class DefaultAnnotationReader implements IEntityClassReader {

	@Override
	public <E> boolean canRead(Class<E> entityClass) {
		return entityClass.isAnnotationPresent(Table.class);
	}
	@SuppressWarnings({ "rawtypes", "unchecked" })
	@Override
	public <E> EntityClassDescriber<E> read(Class<E> entityClass) {
		EntityClassDescriber d = new EntityClassDescriber(entityClass);
		Table table = entityClass.<Table>getAnnotation(Table.class);
		if (table == null)
			throw new IllegalArgumentException("Class do's not have table annotation.class:" + entityClass);
		EntityMeta<E> m = new EntityMeta(entityClass, table.name());
		d.setEntityMeta(m);
		List<EntityFieldDescriber> fieldDescribers = getFieldDescribers(m, entityClass);
		d.setFieldDescribers(fieldDescribers);
		return d;
	}
	

	public static  List<EntityFieldDescriber> getFieldDescribers(EntityMeta<?> entityMeta, Class<?> entityClass) {
		List<EntityFieldDescriber> result = new ArrayList<>();
		Field[] fields = entityClass.getDeclaredFields();

		for (Field f : fields) {
			EntityFieldDescriber fd = readField(entityMeta, f);
			if(fd != null) {
				result.add(fd);
			}
		}
		if (!entityClass.getSuperclass().equals(Object.class)) {
			List<EntityFieldDescriber> superFields = getFieldDescribers(entityMeta, entityClass.getSuperclass());
			List<EntityFieldDescriber> filtedFields = superFields.stream().filter(f->!isExists(result,f)).collect(Collectors.toList());
			result.addAll(filtedFields);
		}
			
		return result;
	}
	private static boolean isExists(List<EntityFieldDescriber> rs,EntityFieldDescriber d) {
		return rs.stream().filter(r->r.getFieldMeta().getPropertyName().equals(d.getFieldMeta().getPropertyName())).findAny().isPresent();
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	private static  EntityFieldDescriber readField(EntityMeta<?> entityMeta, Field f) {
		Column col = f.getAnnotation(Column.class);
		if (col == null) {
			return null;
		}
		EntityFieldDescriber fd = new EntityFieldDescriber();
		fd.setField(f);
		Class<?> fieldType = f.getType();
		JdbcType jdbcType = col.jdbcType();
		if (jdbcType == null || JdbcType.NULL.equals(jdbcType)) {
			jdbcType = DefaultJdbcTypeRegistry.getDefaultJdbcType(fieldType);
		}
		if (jdbcType == null)
			throw new UnknownJdbcTypeException(fieldType,"jdbc type not found:"+fieldType);
		FieldMeta fieldMeta = new FieldMeta(entityMeta, f.getType(), f.getName(), col.name());
		fieldMeta.setJdbcType(jdbcType);
		
		Id id = f.getAnnotation(Id.class);
		if(id!=null) {
			fieldMeta.setPrimaryKey(true);
			fieldMeta.setIdStrategy(id.strategy());
			fieldMeta.setIdStrategyClass(id.strategyClass());
		} else {
			fieldMeta.setPrimaryKey(false);
		}
		fieldMeta.setUpdatable(col.updatable());
		fieldMeta.setInsertable(col.insertable());
		fieldMeta.setJdbcType(jdbcType);
		fieldMeta.setLength(col.length());
		fieldMeta.setNullable(col.nullable());
		fieldMeta.setComment(col.comment());
		boolean isIndexed = fieldMeta.isPrimaryKey();
		if(!isIndexed) {
			Indexed indexed = f.getAnnotation(Indexed.class);
			isIndexed = (indexed!=null);
		}
		fieldMeta.setIndexed(isIndexed);
		fd.setFieldName(f.getName());
		fd.setFieldMeta(fieldMeta);
		return fd;
	}


}
