package plus.ibatis.hbatis.core.util;

import java.math.BigDecimal;
import java.sql.Blob;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import plus.ibatis.hbatis.core.type.JdbcType;
/**
 * java type to jdbc type
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public final class DefaultJdbcTypeRegistry {

	private static final Map<Class<?>, JdbcType> jdbcTypeMap = new HashMap<Class<?>, JdbcType>() {
		/**
		 * 
		 */
		private static final long serialVersionUID = -5302727745166102178L;

		{
			put(Integer.class, JdbcType.INTEGER);
			put(int.class, JdbcType.INTEGER);
			
			put(Long.class, JdbcType.BIGINT);
			put(long.class, JdbcType.BIGINT);
			
			put(Short.class, JdbcType.SMALLINT);
			put(short.class, JdbcType.SMALLINT);
			
			put(Float.class, JdbcType.FLOAT);
			put(float.class, JdbcType.FLOAT);
			
			put(Double.class, JdbcType.DOUBLE);
			put(double.class, JdbcType.DOUBLE);
			
			put(BigDecimal.class, JdbcType.DECIMAL);

			put(String.class, JdbcType.VARCHAR);

			put(Byte.class, JdbcType.TINYINT);

			put(Boolean.class, JdbcType.BOOLEAN);
			put(boolean.class, JdbcType.BOOLEAN);
			
			put(Date.class, JdbcType.TIMESTAMP);

			put(Blob.class, JdbcType.BLOB);

		}
	};
	
	public static JdbcType getDefaultJdbcType(Class<?> clazz){
		return jdbcTypeMap.get(clazz);
	}
}
