package plus.ibatis.hbatis.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import plus.ibatis.hbatis.core.metaDescriber.EntityClassDescriber;
import plus.ibatis.hbatis.core.metaDescriber.IEntityClassReader;
import plus.ibatis.hbatis.core.metaDescriber.adapter.DefaultAnnotationReader;
import plus.ibatis.hbatis.core.metaDescriber.adapter.JpaAnnotationReader;

/**
 * EntityClassDescriberHelper
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class EntityClassDescriberHelper {
	private EntityClassDescriberHelper() {}
	private static Map<Class<?>, EntityClassDescriber<?>> holder = new ConcurrentHashMap<>();

	private static List<IEntityClassReader> readers = new ArrayList<>();
	static {
		// default
		readers.add(new DefaultAnnotationReader());
		// jpa
		readers.add(new JpaAnnotationReader());
	}
	/**
	 * get entity class describer
	 * @param <E> EntityClass
	 * @param entityClass 
	 * 			a instance of entity class
	 * @return EntityClassDescriber
	 */
	@SuppressWarnings({ "unchecked"})
	public static <E> EntityClassDescriber<E> getEntityClassDescriber(Class<E> entityClass) {
		EntityClassDescriber<E> d = (EntityClassDescriber<E>) holder.get(entityClass);
		if (d == null) {
			synchronized(readers){
				for(IEntityClassReader reader:readers) {
					boolean flag = reader.canRead(entityClass);
					if(flag) {
						d = reader.read(entityClass);
						break ;
					}
				}
				holder.put(entityClass, d);
			}
		}
		return d;
	}
}
