package plus.ibatis.hbatis.core.util;


import static java.util.Locale.ENGLISH;

import java.lang.reflect.Method;

import org.apache.ibatis.reflection.property.PropertyNamer;

import plus.ibatis.hbatis.core.lambda.LambdaMeta;
import plus.ibatis.hbatis.core.lambda.ReflectLambdaMeta;
import plus.ibatis.hbatis.core.lambda.SFunction;
import plus.ibatis.hbatis.core.lambda.SerializedLambda;
import plus.ibatis.hbatis.core.lambda.ShadowLambdaMeta;

/**
 * Lambda 解析工具类
 *
 * @author HCL, MieMie
 * @since 2018-05-10
 */
public final class LambdaUtils {

    /**
     * 该缓存可能会在任意不定的时间被清除
     *
     * @param func 需要解析的 lambda 对象
     * @param <T>  类型，被调用的 Function 对象的目标类型
     * @return 返回解析后的结果
     */
    public static <T> LambdaMeta extract(SFunction<T, ?> func) {
        
        // 2. 反射读取
        try {
            Method method = func.getClass().getDeclaredMethod("writeReplace");
            method.setAccessible(true);
            return new ReflectLambdaMeta((SerializedLambda) method.invoke(func), func.getClass().getClassLoader());
        } catch (Throwable e) {
            // 3. 反射失败使用序列化的方式读取
            return new ShadowLambdaMeta(SerializedLambda.extract(func));
        }
    }

    /**
     * 格式化 key 将传入的 key 变更为大写格式
     *
     * <pre>
     *     Assert.assertEquals("USERID", formatKey("userId"))
     * </pre>
     *
     * @param key key
     * @return 大写的 key
     */
    public static String formatKey(String key) {
        return key.toUpperCase(ENGLISH);
    }
    /**
     * extractProperty
     * @param <T> Class
     * @param func extractProperty function
     * @return property name
     */
    public static <T> String extractProperty(SFunction<T, ?> func) {
        
    	LambdaMeta meta = extract(func);
		String prop = PropertyNamer.methodToProperty(meta.getImplMethodName());
	    return prop;
    }
    
}
