package plus.ibatis.hbatis.keygen;

import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;

import plus.ibatis.hbatis.core.meta.FieldMeta;

public abstract class AbstractKeyGenerator implements KeyGenerator {

	@SuppressWarnings("rawtypes")
	private FieldMeta fieldMeta;

	public AbstractKeyGenerator(@SuppressWarnings("rawtypes") FieldMeta fm) {
		this.fieldMeta = fm;
	}

	@Override
	public void processBefore(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
		if (parameter != null) {
			Collection<Object> collections = getParameters(parameter);
			for (Object obj : collections) {
				processParam(ms.getConfiguration(), obj);
			}

		}

	}

	private void processParam(Configuration configuration, Object obj) {
		final MetaObject metaParam = configuration.newMetaObject(obj);
		if (!metaParam.isCollection()) {
			String property = fieldMeta.getPropertyName();
			if (!metaParam.hasGetter(property)) {
				throw new ExecutorException("No getter found for the keyProperty '" + property + "' in "
						+ metaParam.getOriginalObject().getClass().getName() + ".");
			}
			Object value = metaParam.getValue(property);
			if (value != null && isValid(value)) {
				return;
			}
			value = genKey();
			if (!metaParam.hasSetter(property)) {
				throw new ExecutorException("No setter found for the keyProperty '" + property + "' in "
						+ metaParam.getOriginalObject().getClass().getName() + ".");
			}
			metaParam.setValue(property, value);
		}
	}
	public abstract boolean isValid(Object value) ;
	
	public abstract Object genKey();

	@SuppressWarnings({ "rawtypes", "unchecked" })
	private Collection<Object> getParameters(Object parameter) {
		Collection<Object> parameters = null;
		if (parameter instanceof Collection) {
			parameters = (Collection) parameter;
		} else if (parameter instanceof Map) {
			Map parameterMap = (Map) parameter;
			if (parameterMap.containsKey("collection")) {
				parameters = (Collection) parameterMap.get("collection");
			} else if (parameterMap.containsKey("list")) {
				parameters = (List) parameterMap.get("list");
			} else if (parameterMap.containsKey("array")) {
				parameters = Arrays.asList((Object[]) parameterMap.get("array"));
			}
		}
		if (parameters == null) {
			parameters = new ArrayList<Object>();
			parameters.add(parameter);
		}
		return parameters;
	}

	@Override
	public void processAfter(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
		
	}

}
