package plus.ibatis.hbatis.keygen;

import plus.ibatis.hbatis.core.meta.FieldMeta;

public class ObjectIdKeyGenerator extends AbstractKeyGenerator {

	public ObjectIdKeyGenerator(@SuppressWarnings("rawtypes") FieldMeta fm) {
		super(fm);
	}

	@Override
	public boolean isValid(Object value) {
		if(value == null ) return false;
		if(value instanceof ObjectId) return true;
		return ObjectId.isValid(value.toString());
	}

	@Override
	public Object genKey() {
		return ObjectId.get().toHexString();
	}

}
