package plus.ibatis.hbatis.orm;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import plus.ibatis.hbatis.orm.mapper.HbatisMapper;
import plus.ibatis.hbatis.orm.sql.KeyGeneratorBuilder;
/**
 * HBatisConfiguration
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class HBatisConfiguration {

	private static Properties props = new Properties();
	private static Class<?> BASE_MAPPER = HbatisMapper.class;
	static {
		// load config
		InputStream in = null;
		try {
			in = HBatisConfiguration.class.getResourceAsStream("hbatis.properties");
			props.load(in);
		} catch (Exception e) {
			throw new RuntimeException("cannot find config properties:hbatis.properties", e);
		} finally {
			try {
				in.close();
			} catch (IOException e) {

			}
		}

	}
	public static Class<?> getBaseMapper(){
		return BASE_MAPPER;
	}
	public static void setBaseMapper(Class<?> mapperClass) {
		BASE_MAPPER = mapperClass;
	}
	/**
	 * @param dialect
	 * 			database dialect
	 * @param methodName
	 * 			method name
	 * @return SqlBuilder
	 * @throws ClassNotFoundException class not found
	 */
	protected static Class<?> getSqlBuilderClass(String dialect, String methodName) throws ClassNotFoundException {
		String key = "sqlBuilder.%s.%s";
		String className = props.getProperty(String.format(key, dialect, methodName));
		if (className == null) {
			className = props.getProperty(String.format(key, "default", methodName));
		}
		if (className == null) {
			throw new RuntimeException("couldn't find statement sqlsource[dialect:" + dialect + ",methodName:" + methodName + "]");
		}
		return Class.forName(className);

	}
	@SuppressWarnings("unchecked")
	public static Class<KeyGeneratorBuilder> getKeyGeneratorBuilder(String dialect) throws ClassNotFoundException{
		String key = "keyBuilder.%s";
		String className = props.getProperty(String.format(key, dialect));
		if (className == null) {
			className = props.getProperty(String.format(key, "default"));
		}
		if (className == null) {
			throw new RuntimeException("couldn't find key builder[dialect:" + dialect+ "]");
		}
		return (Class<KeyGeneratorBuilder>) Class.forName(className);
	}
}
