package plus.ibatis.hbatis.orm;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import plus.ibatis.hbatis.orm.sql.SqlBuilder;

/**
 * HBatisSqlBuilderFactory
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class HBatisSqlBuilderFactory {

	private static Map<String,HBatisSqlBuilderFactory> instances = new ConcurrentHashMap<>();
	public static HBatisSqlBuilderFactory getInstance(String dialect) {
		return instances.computeIfAbsent(dialect,(key)-> new HBatisSqlBuilderFactory(dialect));
	}
	private String dialect;
	
	private Map<String,Class<?>> sqlBuilders = new HashMap<>();
	private HBatisSqlBuilderFactory(String dialect){
		this.dialect = dialect;
	}
	
	public String getDialect() {
		return dialect;
	}

	public <T extends SqlBuilder> void regist(String methodName,Class<T> sqlBuilderClass) {
		this.sqlBuilders.put(methodName, sqlBuilderClass);
	}
	public Class<?> get(String methodName) {
		return sqlBuilders.get(methodName);
	}
	/**
	 * 获取方法对应SqlBuilder
	 * @param dialect
	 * 			db dialect
	 * @param methodName
	 * 			method name
	 * @return SqlBuilder
	 * @throws ClassNotFoundException SqlBuilder class not found
	 */
	public static Class<?> getSqlBuilderClass(String dialect,String methodName) throws ClassNotFoundException {
		Class<?> tmp = HBatisSqlBuilderFactory.getInstance(dialect).get(methodName);
		if(tmp == null) {
			tmp = HBatisConfiguration.getSqlBuilderClass(dialect, methodName);
		}
		return tmp;
		
	}
}